# Defining your association rules' granularity


> [As defined in the appendix](article:30), the transaction context is all the information, unrelated to the items, that you can capture at the time when the transaction is paid. It can involve multiple dimensions, among which: 
> 
> - Shop's attributes: 
>   - The shop's location: its belonging city, region, country ...
>   - The shop's category: small shop, supermarket, hypermarket, ...
>   - Other shop's attributes.
>   
> - Customers' attributes: 
>   - The customers' provenance: living city, region, country ...
>   - The customers' age category. 
>   - The customers' segment (if you already have a customer segmentation project).
>   - Other customers' attributes.
>   
>  - Business information: 
>    - Promotion period.

The transaction context itself can have an impact on purchasing patterns. In effect, your customers could behave differently : 
- Depending on the regions, the cities or the stores themselves (assuming you sell products physically).
- Depending on the country they come from or their seniority category  (assuming you sell items online).
- Depending on their segment/clusters (if you computed that information).
- Etc...

Thus, the **Market Basket Analysis** will let you learn **granular association rules**. For example, you could learn a set of rules dedicated to each region, city, store, purchasing country and/or customer segment, linked to your transactions.