# Section presentation

The *Association rules computation* section lets you define the parameters linked to the association rule learning process.

![dku_app_association_rules_computation.png](mQnipitVaTfH)

# Section interactions

## Association rules scope

![association_rules_scope.png](WLMOXG5yusOk)

This section helps in defining one of the key features of the **Market Basket Analysis** features: the association rules scope.

### Computing refined rules

In the ["Transactions"](article:22) article we explain that transactions can have information linked to their context or the characteristics of the items they contain. You could be interested in exploiting this available information to learn refined rules. 
You could for example have different purchasing patterns depending on the countries your customers come from. Thus, some association rules learned might not be relevant to be used for some customers depending on the country they live in. Worst, having too important differences in the purchasing patterns could lead to missing some association rules. The information of the transaction country [transactions_dataset](dataset:transactions_dataset) could be used to learn a set of rules compartmentalized for each country.


### Association rules scope

Once the *Compute refined rules* activated, you can define your *rules scope*: this is the set of column(s) of interest that can be used to learn association rules compartmentalized on their values (or combined values if multiple columns are involved in the *rules scope*).


## Transactions specific

![transactions_specific.png](KcU2psvhuyOp)

### Minimum amount of transactions

You can here define the minimum amount of transactions you want to have before looking for any association rule. Since the association rules and their metrics ([Learn more about the association rule metrics](article:11)) depend on items frequencies, having a too small set of transactions could increase the likelihood of having some co-occurring items frequencies that are too far from the business reality, resulting in misleading rules.

In the case you defined a *rules scope*, this minimum amount of transaction will be checked for each possible value within your *rules scope*.


## Frequent itemsets selection

![frequent_itemsets_selection.png](vKnIH0XsnWjp)

This section helps to configure how you want your itemsets to be computed ([What is an itemset ?](article:21)).

### Itemsets min frequency

This parameter defines the minimum frequency, or *support* ([What is an itemset support ?](article:24)), required for an itemset before using it for an association rule ([How association rules are found ?](article:9)).

### Maximum frequent itemsets size

An association rule being a relationship between an antecedent and a consequent itemset, you can here define the maximum size (i.e.: "the number of items they contain") of these itemsets.


## Association rules filtering

![dku_app_association_rules_filtering.png](7FINXBcex8hG)

All the rules extracted from your information may not respect your business criteria. This menu lets you define the minimum thresholds for each rule metric ([Learn more about the association rule metrics](article:11)) before any rule can be considered valid (hence, "actionable") and ready to be used for analysis or recommendation purposes.

## Compute association rules

![compute_association_rules.png](48Hy1FWPMFNl)

Finally, clicking on this button will take into account the parameters you set in both this section and the section  [Transactions preprocessing](article:50) to build of all datasets in flow-zones [transactions_preprocessing](flow_zone:3La1CrK), [association_rules_computation](flow_zone:2SNOOIG) and [association_rules_filtering](flow_zone:b0BsCoE) (Articles : [Inputs](article:49), [transactions_preprocessing](article:40), [association_rules_computation](article:41), [association_rules_filtering](article:42) describe these flow-zones content).