# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
from market_basket_analysis.dku_utils import get_current_project_and_variables
from market_basket_analysis.association_rules import melt_from_rules_to_items_recommendation
from market_basket_analysis.config.flow.constants import ITEMS_RECOMMENDATION_SCHEMA

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
import re
import json

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Read recipe inputs
cross_sales_best_actionable_rules = dataiku.Dataset("cross_sales_best_actionable_rules")
cross_sales_best_actionable_rules_df = cross_sales_best_actionable_rules.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
project, variables = get_current_project_and_variables()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
compute_refined_rules = variables["standard"].get("compute_refined_rules_app")

if compute_refined_rules :
    association_rules_scope = variables["standard"].get("association_rules_scope_app")
else:
    association_rules_scope = []

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
cross_sales_best_actionable_rules_df = melt_from_rules_to_items_recommendation(cross_sales_best_actionable_rules_df)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
cross_sales_best_actionable_rules_df = \
cross_sales_best_actionable_rules_df[association_rules_scope+ITEMS_RECOMMENDATION_SCHEMA]

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
cross_sales_recommendations = dataiku.Dataset("cross_sales_recommendations")
cross_sales_recommendations.write_with_schema(cross_sales_best_actionable_rules_df)