# 定義

エンコードされたトランザクションは、アソシエーションルール検索に必要な形式を持つトランザクションです。トランザクションのエンコードとは、生のトランザクション（[トランザクションに戻る](article:22)）をその特定の形式に変換することを指します。


# 実際には

トランザクションのエンコードには、2つのステップが必要になります
- トランザクションレベルでの購入商品の集計。
- 集約された商品に[ダミー変数(英語)](https://en.wikipedia.org/wiki/One-hot) oを適用。

# この事例について

## 最初に、生のトランザクションデータについて

以下、トランザクションで購入した商品ごとに1行となります :arrow_down::
![transactions_history.png](h3z9j7Kdg9jT)

## 次に、すべての項目が取引レベルで集計されます

これで1取引につき1行となり、その取引で購入された商品のリストが表示されるようになりました。元々5つの取引があったので、集計後は5行になります。:arrow_down::
![transactions_aggregated.png](AtBeDATBPeQ0)

## 最後にダミー変数を適用します
最終的には1取引につき1行となりますが、特定の商品が取引で購入されたかどうかを示すブーリアン項目を追加しました。これらの列は、その商品が取引で購入された場合は「1」、そうでない場合は「0」の値を持ちます。当初、小売業者が販売した商品は 11 品目であったので、ここでの列数は 11 個となります。:arrow_down::

![transactions_encoded.png](cHAbjptPRcCU)