# 定義
アイテムセット***X***は、単一のアイテム（商品）またはアイテム（商品）***i***のリストであることができます。

## 例:

***X*** = {***i<sub>1</sub>*** , ***i<sub>4</sub>***  }
***X*** = { ***i<sub>5</sub>*** }

## アイテムについて（再掲）
>  ***定義***
アソシエーションルール学習では、商品***i***iは他と一緒に発生する可能性のある単一の商品を識別する。
これらは商品群に属しています ***I***  = { ***i<sub>1</sub>*** , ***i<sub>2</sub>*** , … , ***i<sub>n</sub>***  }.

> ***実際には***
マーケットバスケット分析では、一般的に商品を単品で考えることが多いです。その場合、アソシエーションルール学習を用いて、販売する商品間の関係（あるいは「ルール」）を発見することが目的となります。 しかし、カテゴリやブランドなどの商品情報をアイテムとして捉え、それぞれ小売店のブランドや商品カテゴリ間の関係を発見することもできます。
このように、商品"はアソシエーションルールの中核となるものを指定するための一般的な概念であることがわかる。

# 実際には

商品をアイテムとして考えると、一緒に購入した商品の組み合わせはすべてアイテムセットとして考えることができます
商品は*ベーコン、キャベツ、チキン、コーン、ガーリック、トマト、サラダ、ピーマン、玉ねぎ、トルティーヤ、マッシュルーム*の11品目で構成されています。
- {トマト, トルティーヤ} はアイテムセットとみなせます
- {サラダ、トモと、玉ねぎ}もそうですね
- {キャベツ} もそうです。ここでは、1つの商品だけでもアイテムセットとみなせることを認識してください。

# 今回のユースケース

トランザクションがエンコードされたことで、アイテムセットの識別が容易になりました。
例えば、下記 :arrow_down:のようになります。
- アイテムセット **{<span style="color:#294E14">*bacon/ベーコン*</span>}** は1行目のトランザクション"t_1"にのみ記録されています。
- アイテムセット **{<span style="color:#1D4586">*onion/玉ねぎ, pepper/ピーマン*</span>}** は最初の２行のトランザクション"t_1" と "t_2"に記録されています。

![itemsets.png](JG73mTs6E2pL).

先行商品と後続商品の両方を構成するため、アイテムセットはアソシエーションルール学習の中核をなしている アイテムセットは学習の中核となります。([アソシエーションルールについて](article:23)).