# 定義

ルールの信頼度は、アイテムセット***X***を購入した上で、アイテムセット***Y***を**購入**する確率です。

<span style="color:#9900FE">**conf(**</span>***X => Y *** <span style="color:#9900FE">**)**</span>と表記される。

# 式
 
![rule_confidence_formula.png](6wMFmI6CmggP)

[ルールのサポートについて](article:25)

# コンセプトの深堀

- ルールの信頼度が高いほど、**アソシエーションルールで先行商品を満たした後に後続商品を購入する可能性が高い**

- <span style="color:#9900FE">**conf(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> **[0, 1]** の一部です。
  - <span style="color:#9900FE">**conf(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> は***X*** と ***Y*** が常に同時購入されていると最大となります
  - <span style="color:#9900FE">**conf(**</span>***X => Y*** <span style="color:#9900FE">**)**</span>  **!=** <span style="color:#9900FE">**conf(**</span>***Y => X*** <span style="color:#9900FE">**)**</span>.


# ユースケースについて

- 5つのトランザクションがあります
- ルール **{<span style="color:#294E14">bacon => cabbage</span>}**: 
  - **<span style="color:#294E14">bacon</span>** と **<span style="color:#294E14">cabbage</span>** は同時に購入されたことはないです。よって <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon => cabbage</span>}**<span style="color:#9900FE">**)**</span> = 0/5 = 0.
  - **<span style="color:#294E14">bacon</span>** は１つのトランザクションで購入されています。よって <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon</span>}**<span style="color:#9900FE">**)**</span> = 1/5 = 0.2.
  - 最後に<span style="color:#9900FE">**conf(**</span>**{<span style="color:#294E14">bacon => cabbage</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon => cabbage</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#294E14">bacon</span>}**<span style="color:#9900FE">**)**</span> = 0 / 0.2 = 0.
  - <span style="color:#294E14">**cabbage**</span> は <span style="color:#294E14">**bacon**</span>が含まれるトランザクションで購入されたことはありません。


![rules_confidence_p1.png](33DfjqyLklg0)


- ルール**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**: 
  - **<span style="color:#1D4587">pepper</span>**, **<span style="color:#1D4587">onion</span>**  と **<span style="color:#1D4587">mushroom</span>** は２つのトランザクションで同時に購入されています。よって <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - **<span style="color:#1D4587">pepper</span>** と **<span style="color:#1D4587">onion</span>** は２つのトランザクションで同時に購入されています。よって <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - 最後に<span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">pepper,onion</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 0.4 = 1.
  -  <span style="color:#1D4587">**pepper & onion**</span> が購入されている場合は100%の確率で<span style="color:#1D4587">**mushroom**</span> 購入に至っています。逆に言うと <span style="color:#1D4587">**mushroom**</span>の購入は、 <span style="color:#1D4587">**pepper & onion**</span>が購入されているときに 1.0となります。

![rules_confidence_p2.png](oX0v3NiLSde4)


- ルール **{<span style="color:#990002">tomato => salad</span>}**: 
  - **<span style="color:#990002">tomato</span>** と **<span style="color:#990002">salad</span>** は２つのトランザクションで同時に購入されています。よって <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - **<span style="color:#990002">tomato</span>** は全５つのトランザクションで同時に購入されています。よって  <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato</span>}**<span style="color:#9900FE">**)**</span> = 5/5 = 1.
  - 最後に<span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">tomato</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 1 = 0.4. 
  - <span style="color:#990002">**tomato**</span> が購入されたトランザクションのうち40%は <span style="color:#990002">**salad**</span> の購入に至っています。
  
  
- ルール **{<span style="color:#990002">salad => tomato</span>}**: 
  - **<span style="color:#990002">salad</span>** と **<span style="color:#990002">tomato</span>** は２つのトランザクションで同時に購入されています。よって <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad => tomato</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - **<span style="color:#990002">salad</span>** は2つのトランザクション"t_3" and "t_5"で購入されています. よって<span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 2/5 = 0.4.
  - 最後に<span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">salad => tomato</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad => tomato</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 0.4 = 1. 
  - <span style="color:#990002">**tomato**</span> が購入された場合、100%がled to the purchase of <span style="color:#990002">**salad**</span> の購入に至っています。

![rules_confidence_p3.png](tkBkjgpsQm8C)
