# 定義

ルールの**リフト**は、そのルールを使用することが、**独立して得られた結果に頼るよりもどの程度優れているかを示します**

<span style="color:#9900FE">**lift(**</span>***X => Y *** <span style="color:#9900FE">**)**と表記されます。
  
# 式

![rule_lift_formula.png](pOqf2xH65JJU)

[ルールサポートとは](article:25)
[ルールの信頼度とは](article:26)

# コンセプトの深堀

- これは、**アソシエーション・ルールの強さ**を示す指標です。ルールのリフトが高いほど、それを使用する価値が高いとされます。
- <span style="color:#9900FE">**lift(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> ** [0, +inf]** の一部です。
  - <span style="color:#9900FE">**lift(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> > 1の場合: 先行と後続のアイテムセットが互いに依存していることを示唆しています。アイテムセットは独立して購入されるよりも、一緒に購入されることが多いとなります。
  -  <span style="color:#9900FE">**lift(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> <= 1場合: アイテムセットは統計的に独立しているが示唆されます。


# ユースケースについて

- 5つのトランザクションがあります

- ルール **{<span style="color:#1D4587">pepper,onion => mushroom</span>}**:

  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span>  = 1.
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">mushroom</span>}**<span style="color:#9900FE">**)**</span> = 3/5 = 0.6. 
  - 最後に: <span style="color:#9900FE">**lift(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">mushroom</span>}**<span style="color:#9900FE">**)**</span> = 1 / 0.6 = 1.67
  - <span style="color:#1D4587">**mushroom**</span>の購入は<span style="color:#1D4587">**pepper & onion**</span> の購入に依存していると考えられます。

![rules_lift_p3.png](iajhGiftguow)

- ルール **{<span style="color:#990002">tomato => salad</span>}**: 
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
    - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
  - 最後に: <span style="color:#9900FE">**lift(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4 / 0.4 = 1.
  - <span style="color:#990002">**tomato**</span> と <span style="color:#990002">**salad**</span> は独立した商品であるようです。

![rules_lift_p2.png](y4wdojJr9C6O)

- ルール **{<span style="color:#7F6000">onion => tortilla</span>}**:
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.5.
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#7F6000">tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.6.
  - 最後に : <span style="color:#9900FE">**lift(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> = <span style="color:#9900FE">**conf(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> / <span style="color:#9900FE">**supp(**</span>**{<span style="color:#7F6000">tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.5 / 0.6 = 0.83.
  - <span style="color:#7F6000">**onion**</span> と <span style="color:#7F6000">**tortilla**</span> は独立した商品であるようです。

![rules_lift_p1.png](Gj1WkIdrVsRA)





