# 定義

ルールの**納得度**は、先行するアイテムセットに対する後続のアイテムセットの依存関係の強さを測定します。
<span style="color:#9900FE">**conv(**</span>***X => Y *** <span style="color:#9900FE">**)**として表記されます。
  
# 式

![rule_conviction_formula.png](QkIM3ZxNVg8g)

[ルールサポートとは](article:25)
[ルールの信頼度](article:26)

# コンセプトの深堀

- (XとYが独立であると仮定して）XがYなしに発生する確立と、XがYなしに発生する確立の比となります
- 納得度が高いとは、後続のアイテムセットが先行アイテムセットに強く依存していることを意味します。
  -  <span style="color:#9900FE">**conf(**</span>***X => Y *** <span style="color:#9900FE">**)**</span> が最大のとき、分母は0になります。したがって、<span style="color:#9900FE">**conv(**</span>***X => Y *** <span style="color:#9900FE">**)**</span>は無限大に発散することを意味します
- <span style="color:#9900FE">**conv(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> **が[0, +inf]**の一部だった場合：
  - <span style="color:#9900FE">**conv(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> > 1: 後続のアイテムセットは先行のアイテムセットに強く依存することを示唆します
  -  If <span style="color:#9900FE">**conv(**</span>***X => Y*** <span style="color:#9900FE">**)**</span> <= 1: 後続のアイテムセットは先行のアイテムセットが統計的に独立していることを示唆する。

# ユースケースについて

- 5つのトランザクションがあります

- ルール **{<span style="color:#1D4587">pepper,onion => mushroom</span>}**:

  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#1D4587">mushroom</span>}**<span style="color:#9900FE">**)**</span> = 3/5 = 0.6. 
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span>  = 1.
  - 最後に： <span style="color:#9900FE">**conv(**</span>**{<span style="color:#1D4587">pepper,onion => mushroom</span>}**<span style="color:#9900FE">**)**</span>  = (1 - 0.6) / (1 - 1) = +inf.
  - <span style="color:#1D4587">**mushroom**</span> の購入は<span style="color:#1D4587">**pepper & onion**</span> の購入に依存していることが示唆できます。

![rules_conviction_p3.png](xYlme9cYkoJY)

- ルール **{<span style="color:#990002">tomato => salad</span>}**: 
    - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#990002">salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
    - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = 0.4.
  - 最後に: <span style="color:#9900FE">**conv(**</span>**{<span style="color:#990002">tomato => salad</span>}**<span style="color:#9900FE">**)**</span> = (1 - 0.4) / (1 - 0.4) = 1.
  - <span style="color:#990002">**tomato**</span> と <span style="color:#990002">**salad**</span> は独立した商品であることが示唆できます。

![rules_conviction_p2.png](c5K5HoP8nFqY)

- ルール **{<span style="color:#7F6000">onion => tortilla</span>}**:
  - <span style="color:#9900FE">**supp(**</span>**{<span style="color:#7F6000">tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.6.
  - <span style="color:#9900FE">**conf(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span> = 0.5.
  - 最後に : <span style="color:#9900FE">**conv(**</span>**{<span style="color:#7F6000">onion => tortilla</span>}**<span style="color:#9900FE">**)**</span>  = (1 - 0.6) / (1 - 0.5) = 0.8.
  - <span style="color:#7F6000">**onion**</span>と <span style="color:#7F6000">**tortilla**</span> は独立した商品であることが示唆できます。

![rules_conviction_p1.png](TS8NRBRAlXXc)





