# フローゾーンの概要

ここでは、[レコメンデーションの前処理](flow_zone:1QYvNls)フローゾーンについて記載します。

![recommendations_preprocessing.png](YipQfSXh6u9O)

フローゾーンの主処理の概要は以下の通りです:

 - **顧客購入時に記録されるトランザクション日に関するフィルタリング** : レシピ[compute_transactions_customers_filtered_dates](recipe:compute_transactions_customers_filtered_dates)
 
 - **有効な取引日の期間内の直近N件のトランザクションをフィルタリング** : レシピ[compute_customers_last_transactions](recipe:compute_customers_last_transactions) は、顧客のトランザクションのランク付けし、最後の「N」個を取り出すためにポストフィルターを使用します（「N」はdataikuアプリケーションの「last parameter scope」で設定ができるパラメータです）。
 
 - **フィルタリングされたトランザクションの中で、顧客が購入したすべての異なるアイテムの算出** : これはレシピ[compute_customers_last_transactions_unique_items](recipe:compute_customers_last_transactions_unique_items)で実行され、[customers_last_transactions_unique_items_prepared](dataset:customers_last_transactions_unique_items_prepared)データセットが作成されます。
 
 - **購入したユニーク顧客の算出** : レシピ [compute_unique_customers](recipe:compute_unique_customers)によって実行されています
 
 - **追加で購入する可能性がある各顧客の算出** : レシピ [compute_consequents_potential_customers](recipe:compute_consequents_potential_customers)では、  アソシエーション・ルール内の既存の各結果を、各顧客 id と交差させます。これにより、すべての帰結が潜在顧客となるデータセット[consequents_potential_customers](dataset:consequents_potential_customers)が得られます。
   - このデータセットには *number_of_consequent_items（品目数）* X *number_of_customers（顧客数）* の行数があります。
   - データセットの粒度:１行 = 1つの品目と1つの顧客の間の1つの組み合わせ。
   - これはレシピ [compute_unique_consequent_items](recipe:compute_unique_consequent_items) がデータセット [rules_denormalized_consequents](dataset:rules_denormalized_consequents)にアソシエーションルールが 適用されたことによって算出できています。 ([データセットについて?](article:57)) 
   
 - **すべての「クロスセル」「アップセル」（=「リピート購入」）候補の算出**。これは データセット [consequents_potential_customers](dataset:consequents_potential_customers) とデータセット[customers_last_transactions_unique_items_prepared](dataset:customers_last_transactions_unique_items_prepared)から算出されています。
   - レシピ [compute_cross_sales_candidate_consequents](recipe:compute_cross_sales_candidate_consequents)　では商品の追加購入がなかった顧客の一覧を保管します。最後にレシピ[compute_cross_sales_candidate_consequents_prepared](recipe:compute_cross_sales_candidate_consequents_prepared)では[クロスセルのレコメンデーション](article:47)を保管します。
   - レシピ [compute_up_sales_candidate_consequents](recipe:compute_up_sales_candidate_consequents)では商品の追加購入があった顧客の一覧を保管します。最後にレシピ[compute_up_sales_candidate_consequents_prepared](recipe:compute_up_sales_candidate_consequents_prepared) でデータセット[レピート購入のレコメンデーション](article:46)を準備します。