# フローゾーンの概要
ここでは、[クロスセルレコメンデーション](flow_zone:X2Yv1zo)フローゾーンについて記載します。

![cross_sales_recommendations.png](doHt5Ur7izBt)
 
フローゾーンの主処理の概要は以下の通りです:
 
 - **クロスセルの候補となるすべてのルールを算出**: レシピ [compute_cross_sales_candidate_rules](recipe:compute_cross_sales_candidate_rules)では ([レコ目園デーションの前処理](article:45))で準備されたデータセットと[valid_rules_denormalized_consequents](dataset:valid_rules_denormalized_consequents) データセットを結合し、その結果につながるルールの情報（「rule_id」と「ルールメトリクス」）をすべて取得します。その結果、データセット[cross_sales_candidate_rules](dataset:cross_sales_candidate_rules)が生成されます。 **この段階ではまだ候補としている理由は**、この結合で取得されたルールはすべて実行可能ではないからです。実行可能にするには、ルールを起動するために必要なすべての先行商品も購入されていることを確認する必要があります。
 
 - **ルール候補のトリガーに必要なすべての商品を算出**: これはレシピ[compute_cross_sales_required_antecedents](recipe:compute_cross_sales_required_antecedents) によって実施されます。このレシピではデータセット [cross_sales_candidate_rules](dataset:cross_sales_candidate_rules) と[rules_denormalized_antecedents](dataset:rules_denormalized_antecedents)  ([このデータセットの中身について](article:57))が結合され データセット[cross_sales_required_antecedents](dataset:cross_sales_required_antecedents)が生成されます。
 
 - **ルール候補の発動に必要な先行商品が購入されたかどうかをチェック**: これはレシピ[compute_cross_sales_purchased_antecedents](recipe:compute_cross_sales_purchased_antecedents)によって実施されます。このレシピではデータセット [cross_sales_required_antecedents](dataset:cross_sales_required_antecedents) とデータセット [customers_last_transactions_unique_items_prepared](dataset:customers_last_transactions_unique_items_prepared)が結合され、先行商品が顧客によって購入された行をフィルタリングします。しかし、ルールを起動するために必要なすべての先行商品が購入されたかどうかは、この時点では判明していません。その情報は、次の2つのレシピで生成されます。
 
 - **実行可能ルールの特定**. ２つのステップで実施されます : 
   - **「顧客＋ルール」レベルでの先行購入された製品のピボット**: レシピ[compute_cross_sales_rules_summary](recipe:compute_cross_sales_rules_summary) によって実施されます。このレシピではデータセット[cross_sales_rules_summary](dataset:cross_sales_rules_summary) が生成され、カラム"purchased_count"では、顧客が先行購入すべき商品数が算出されています。
   - **購入が必要な先行商品数と、ルールが算出した先行商品数が一致しているかを確認する**: その場合、顧客は先行商品を全て購入しているため、ルールは実行可能になります。 レシピ[compute_cross_sales_actionable_rules](recipe:compute_cross_sales_actionable_rules) ではそのチェックを実施し、実行可能なルールのみをキープしデータセット[cross_sales_actionable_rules](dataset:cross_sales_actionable_rules)を生成します。
 
- **最適なアクション可能なルールのみを保持する**: 複数のルールが同じアイテムセットを導くことがあります。したがって、それらすべてを保持する必要はなく、各アイテムセットにつながる最適なルールだけを保持することが最適です。この「最適なルール」という概念は、優先したいルールの指標に依存するため、dataikuアプリの[Customers rules recommendations/顧客レコメーンデーションルール](article:53)の項目で設定することができます。レシピ[compute_cross_sales_best_actionable_rules](recipe:compute_cross_sales_best_actionable_rules)は、メトリックの優先順位付けを考慮し、各顧客について、最適なアイテムセットにつながるルールを保持します。
 
- **結果的商品について最適なアクション可能なルールのみを保持する**: アイテムセット([アイテムセットについて](article:21))は、複数のアイテムから構成されています。したがって、アイテムセットにつながる最適なルールを分離したとしても、多くは同じ商品（アイテム）のレコメンデーションにつながる可能性があります
  - レシピ [compute_cross_sales_recommendations](recipe:compute_cross_sales_recommendations)はルールの帰結を非正規化し、「1行＝1顧客に提案した1ルールの帰結項目」のデータセット粒度となるようにしています。 
  - 最後に、レシピ[compute_cross_sales_best_recommendations](recipe:compute_cross_sales_best_recommendations) 設定されたメトリクスの優先順位付けに従って、各商品、各顧客につながる最高のルールを切り分けます。
 

