# セクション概要

*「Association Rule Computation / アソシエーションルールの算出」*セクションでは、アソシエーションルールの学習プロセスに関連するパラメータを定義することができます。

![dku_app_association_rules_computation.png](mQnipitVaTfH)

# セクション内容

## Associations Rule Scope / アソシエーションルールのスコープ

![association_rules_scope.png](WLMOXG5yusOk)

ここでは、**マーケット・バスケット分析**の重要な機能の1つであるアソシエーションルールの範囲を定義するのに役立つ情報を提供します。

### Compute Refined Rules? / ルールの算出?

[トランザクション](article:22)の記事では、トランザクションはそのコンテキストや含まれる項目の特性にリンクした情報を持つことができると説明しました。このような利用可能な情報を利用して、洗練されたルールを学習することに関心があるかもしれません。

例えば、顧客の出身国によって、異なる購買パターンがあるかもしれません。したがって、学習されたアソシエーション・ルールの中には、顧客の居住国によって使用する意味がないものもあるかもしれません。最悪なのは、購買パターンにあまりに重要な違いがあると、いくつかのアソシエーション・ルールが見落とされる可能性があることです。それを避けるため[transactions_dataset](dataset:transactions_dataset) の情報を使って、国ごとに区分けされたルールセットを学習することができます。

### Association Rule Scope / アソシエーションルールのスコープ

*Compute refined rules* が有効になると、*rules scope* を定義することができます。これは、アソシエーションルールを学習するために使用できる関心のあるカラムのセットです（複数の列が *rules scope* に含まれる場合は、それらの値を組み合わせたもの）。

## Transaction Specific / トランザクション指定

![transactions_specific.png](KcU2psvhuyOp)

### Minimum amount of transactions / 最小トランザクション数

ここでは、関連ルールを検索する前に必要なトランザクションの最小量を定義することができます。アソシエーション・ルールとそのメトリクス（[アソシエーション・ルールのメトリクスについてはこちら](article:11)）は項目の頻度に依存するので、トランザクションのセットが少なすぎると、ビジネスの現実からかけ離れた項目が同時に発生する可能性が高まり、結果として誤解を招くルールになる可能性があります。

*Rules Scope / ルールのスコープ*を定義した場合、この最小量のトランザクションは、ルール・スコープ内の可能な値ごとにチェックされます。

## Frequent itemsets selection / 頻繁に出てくるアイテムセットの選択

![frequent_itemsets_selection.png](vKnIH0XsnWjp)

このセクションでは、アイテムセットの算出方法を設定することができます。([アイテムセットとは ?](article:21)).

### Itemsets min frequency / アイテムセット最小頻度

このパラメータは、アイテムセットを[アソシエーションルール](article:9)に使用する前に必要な最小限の出現頻度、または[サポート](article:24)を定義します。

### Maximum frequent itemsets size / アイテムセットの最大サイズ

アソシエーションルールは先行商品と後続商品の間の関係で、ここではこれらのアイテムセットの最大サイズ（すなわち「含まれる商品の数」）を定義することができます。

## Association rules filtering / アソシエーションルールのフィルタリング

![dku_app_association_rules_filtering.png](7FINXBcex8hG)

情報から抽出されたすべてのルールが、ビジネス・クライテリアに適合するとは限りません。このメニューでは、各ルールメトリクス ([アソシエーションルールのメトリクスについて](article:11)) の最小しきい値（ルールが有効（したがって「実行可能」）とみなされ、分析や推薦の目的に使用できるようになる前）を定義することができます。

## Compute association rules / アソシエーションルールの算出

![compute_association_rules.png](48Hy1FWPMFNl)

このボタンをクリックすることで、[トランザクションの前処理](article:50)のパラメーターに則り [トランザクションの前処理](flow_zone:3La1CrK), [アソシエーションルールの処理](flow_zone:2SNOOIG) and [アソシエーションルールのフィルタリング](flow_zone:b0BsCoE) が再構築されます。(記事: [インプット](article:49), [トランザクションの前処理](article:40), [アソシエーションルールの三周つ](article:41), [アソシエーションルールのフィルタリング](article:42)ではこれらのフローゾーンの処理が説明されています)。