# ルールが見つからない場合どうするか？

## アプリケーションキーパラメーターについて
複数のパラメーターが発見するルールに影響をもたらします。

- アソシエーションルールの日付フィルタリング戦略で考慮される期間（[詳細はこちら](article:50)）
  - 重要な季節性を持つ商品や短期間で販売される商品の場合、アソシエーションルールに含まれる可能性を最大化するために、アイテムの販売サイクルの合わせ短期間のウィンドウを設定することが重要になってきます。（したがって、見つけるルールの数が増加する可能性があります）
 
- アイテムの**最小頻度**（[詳細はこちら](article:51)）。必要な最小頻度が高いほど、より少ない頻度のアイテムセットが見つかり、より少ないアソシエーションルールが見つかります。

- ルールを検証する前にルールメトリクスに**閾値値** ( [詳細はこちら](article:51))を設定。信頼度、リフト、納得度の設定を高くすればするほど、有効なルールが少なくなります。ただし、これらの値を上げると、意味のないルールを抽出する可能性があるので、注意が必要です。

- **トランザクションの最小数**。デフォルトでは100に設定されています（[詳細はこちら](article:51)）。つまり、100より少ないトランザクションのグループはフィルタリングされ、アソシエーション・ルールの学習プロセスには考慮されません

- アソシエーション・ルールの範囲（[詳細はこちら](article:51)）。アソシエーション・ルールは、新しく洗練されたルールを見つけるのに役立ちますが、購買パターンがフォーカスする範囲によって異なるため、いくつかのルールが失われる可能性もあります。さらに、ここで紹介する他のパラメータは、アソシエーションルールのスコープに依存する。
  - アイテムセットの最小頻度：各ルール・スコープに存在する各アイテムについて計算される。
  - トランザクションの最小数：各ルール・スコープに関連するトランザクションの各グループについて計算される

## ダッシュボードを使うにあたって
主要なパラメータとそれがプロジェクトに与える影響を知ることで、プロジェクトの[ダッシュボード](article:6)を活用して、アソシエーションルールの学習戦略を練り直すことも可能です。
