# Webアプリの表示方法

このウェブアプリケーションは、最も頻繁に使用する商品のサポートを分析することができます。
さまざまなセクションがあり、独自のフィルタリングを定義することができます。

:warning: **注意１** : 下の画像では、"Country "カラムを*Associations Rule Scope / アソシエーションルール*のスコープとして使ってグラフが計算されています([この概念についてもっと知る](article:51))。ルールスコープを定義しない場合、表示される図は異なります。

![items_frequency_analysis_with_rules_scope.png](rIT2KzFUVNCQ)


# Webアプリヘルプ

Webアプリの文言に慣れていない場合は、いくつかのヘルパーがあります。
![items_frequency_analysis_helpers.png](Gqs4QttxpZdP)
:arrow_up: :*上の最初のスクリーンショットは、ヘルパー・セクションの元の状態を示しています。次に、2番目のスクリーンショットは、「Get wording explanation/文言の説明を受ける」セクションをクリックするとどうなるかを示しています：セクションが展開され、利用可能なサブセクションのいくつかをクリックできるようになったのがわかります。最後に、「What is an item?/商品とは 」というヘルパーをクリックすると、それに関する説明が表示されます。*

# ルールのスコープ(ルールのスコープが定義されている時のみ使用可能)

*ルールスコープ* セクションでは、最も頻繁に観察する項目のルールスコープを選択できます。ここでは、分析するルールスコープを1つまたは複数選択することができます。下図は、複数のルール・スコープをアクティブにした場合の効果を示しています。

*注*: **マーケットバスケット分析**がアソシエーションルールのスコープで動作するように設定されている場合、少なくとも1つのルールスコープを選択する前に、ここで結果が表示されることはありません。

![rules_scope.png](hi3IK9Af2Tvo)
:arrow_up: :*上図、最初のスクリーンショットは、ルールスコープとして「Germany/ドイツ」のみを選択した場合の結果を示しています。このルールスコープに関連する最も頻度の高い項目が赤で表示さています。次に、「Germany/ドイツ」、「EIRE/アイルランド」、「France/フランス」を考慮した場合の結果を示しますが、ルールスコープに属する項目によって棒グラフの色が異なることがわかります。1つ以上のルールスコープを分析した場合、平均頻度の降順に並べられます。*

# 共通商品を見る（ルールのスコープが定義されている時のみ使用可能)

購入パターンは定義したルールスコープによって異なるため、表示され商品の中には、すべてのルールスコープに存在しないものもあります（以下の例では、品目「POSTAGE」がルールスコープ「France/フランス」と「Germany/ドイツ」に存在し、「EIRE/アイルランド」に存在しないことが分かります）。
*Focus on common items/共通商品を見る* オプションを使用すると、少なくとも2つのルールスコープに共通する商品で商品の頻度結果をフィルタリングし、必要に応じてこの閾値を増やすことができます。

*注*: **マーケットバスケット分析**がアソシエーションルールのスコープで動作するように設定されていない場合、こちらのセクションは表示されません。

![focus_on_common_items_with_rules_scope.png](EkTBhaqfk8aE)
:arrow_up: :*最初のスクリーンショットは、「Germany/ドイツ」、「EIRE/アイルランド」、「France/フランス」の3つのルールスコープについて、アイテムが少なくとも2つのスコープに共通している場合に得られる結果を示しています。次に、2つ目のスクリーンショットは、アイテムごとの共通スコープ数を3に設定した場合の結果を示しています：3つの国で購入されたアイテムのみが表示されます。*

# 特定商品に絞る

結果を出した後、その中の一部の商品にフォーカスを当てたいと思うかもしれません。このセクションはそのためのものです。

![focus_on_specific_items.png](PMhpVut5kDcP)
:arrow_up: :*上のスクリーンショットは、3つのルールスコープ「Germany/ドイツ」、「EIRE/アイルランド」、「France/フランス」に対して得られた結果を示しています。次に、「POSTAGE」、「CARRIAGE」、「REGENCY CAKESTAND 3 TIER」*の3つの項目にフォーカスしたときの結果です。

# 最大出現頻度の分析

最大出現頻度の分析で表示する商品の数を設定します。

![max_frequent_items_to_analyze.png](vpSEWLc7bBY3)
:arrow_up: :*最初のスクリーンショットは、最も頻度の高い20商品を分析した結果です。また、2枚目のスクリーンショットは、頻度の高い40商品を分析した結果です。*