## A Three-step Analysis

This section uses univariate modelling to obtain the Survival Probabilities and the Failure Profiles at both the quipment and maintenance operation level. 

First, a [Kaplan-Meier estimator](https://en.wikipedia.org/wiki/Kaplan%E2%80%93Meier_estimator) is used to produce the first plot on the right. Using this plot, we can visualize the percentage of uptimes that were longer than any given number of days for any equipment. This creates an estimation of the survival probability for each number of days and each piece of equipment.the Kaplan-Meier Estimator is used. It provides insights into relative durability by comparing survival probabilities across different equipment units and maintenance operations. 

![kaplan.png](GCn6JIXmFvIY)

Second, the Weibull Distribution is used to model the uptimes of both equipments and maintenance operations. It uncovers failure patterns, helping you to understand the operational behavior of each element. Depending on the result, the equipment or the maintenance operation is classified into one of three profiles:

 - A value of k < 1 indicates that the failure rate decreases over time. This is typically observed in the case of early-life failures (also known as “infant mortality”), where defective components or systems fail early in their operational life. In industrial maintenance, this profile can indicate potential manufacturing defects or improper installation.
 - A value of k = 1 indicates a constant failure rate over time, suggesting random failures . This profile suggests that failures are unpredictable and can occur any time.
 - A value of k > 1 indicates that the failure rate increases with time. This is associated with wear-out failures, where parts or equipment degrade due to aging, fatigue, or wear and tear. Equipment in this profile is likely working as expected.

![weibull.png](nXdMRejTngsf)!

Finally a frequency analysis identifies the most frequent equipment or maintenance operation, allowing for focused troubleshooting and proactive maintenance.

![frequency.png](P5XmNK3zvnvh)

## At the Equipment and the Maintenance Operation Level

After running this analysis to the equipment level, we conduct it at the maintenance operation level, producing similar plots.

![maintenance.png](q8TFFUABOfT5)

## Filters

On the left, it is possible to filter by equipment and / or maintenance operation.

![filter_1.png](i2Syu1zpXcqE)![filter_2.png](1pyufqmOAYRa)