# Data Model for Maintenance Performance and Planning

The Maintenance Performance and Planning solution is designed to work with equipment and maintenance data from industrial facilities. The data model captures both static equipment characteristics and dynamic maintenance events, enabling comprehensive survival analysis to predict maintenance needs and optimize equipment reliability.

## Primary Data Source: Equipment Characteristics Data
**Equipment Information  Dataset**
   - This dataset contains static information about each piece of equipment in the facility.
   - Each row represents one piece of equipment with its operational and environmental characteristics.
   - The schema captures factors known to influence equipment reliability and maintenance requirements.
   - This data serves as the covariate matrix for survival analysis modelling (Cox Proportional Hazards, Weibull, etc.).

The schema of the equipment dataset **must** include:
- `equipment_id` (_string_): Unique identifier for each piece of equipment (e.g., "EQ001", "MC042")

Optionally, the dataset can include any additional column that you wish to integrate in the analysis. Their impact on maintenance performance will be analyzed. In the example dataset, the following columns are available:
- `equipment_type` (_string_): Category of equipment (e.g., "CNC_Mill", "Lathe", "Press", "Grinder", "Conveyor", "Robot_Arm")
- `install_date` (_Date/Timestamp_): Date when equipment was first installed and commissioned
- `technology_generation` (_string_): Technology level/vintage ("Legacy", "Standard", "Advanced")
- `reliability_factor` (_decimal_): Baseline reliability multiplier based on technology generation (0.85-1.15)
- `utilization_rate` (_decimal_): Average operational intensity as fraction of maximum capacity (0.0-1.0)
- `temperature_condition` (_string_): Operating temperature environment ("Low", "Normal", "High")
- `humidity_condition` (_string_): Operating humidity environment ("Low", "Normal", "High")
- `dust_level` (_string_): Dust exposure level in operating environment ("Clean", "Moderate", "Dusty")
- `vibration_level` (_string_): Ambient vibration exposure ("Low", "Normal", "High")
- `pm_compliance_score` (_decimal_): Preventive maintenance adherence score (0.0-1.0, higher is better)
- `operator_skill_level` (_decimal_): Average skill level of operators (0.0-1.0, higher is better)
- `cost_tier` (_string_): Equipment value category ("Low", "Medium", "High")

## Secondary Data Source: Maintenance Events Data
**Maintenance Operations Dataset**
   - This dataset contains time-stamped maintenance events for each piece of equipment.
   - Each row represents a single maintenance event with start and end times.
   - This data provides the survival times and event indicators for survival analysis.
   - Events can be either planned (preventive) or unplanned (corrective) maintenance.

The schema of the maintenance events dataset **must** include:
- `equipment_id` (_string_): Identifier linking to the equipment dataset. This **must** be the same column as in the equipment dataset.
- `equipment_stop_time` (_Timestamp_): When equipment stopped operating (event time)
- `equipment_restart_time` (_Timestamp_): When equipment resumed operation after maintenance
- `is_planned` (_boolean_): Whether the maintenance was scheduled (TRUE) or reactive (FALSE)
- `maintenance_operation` (_string_): Specific type of maintenance performed (e.g., "CM_Bearing_Failure", "PM_Lubrication")

## Sample Data Structure

### Equipment Information Dataset Example
 | equipment_id | equipment_type | install_date | utilization_rate | pm_compliance_score  | 
| --- | ---  | --- | --- |  --- | 
 | EQ001       | CNC_Mill       | 2018-03-15   | 0.847           | 0.923  | 
 | EQ002       | Conveyor       | 2020-07-22   | 0.634           | 0.856  | 
 | EQ003       | Press          | 2019-11-08   | 0.782           | 0.741  | 

### Maintenance Operations Dataset Example
| equipment_id | equipment_stop_time     | is_planned | maintenance_operation| 
| --- | ---  | --- | --- | 
| EQ001       | 2023-04-12 14:30:00    | FALSE      | CM_Bearing_Failure | 
| EQ001       | 2023-06-18 09:00:00    | TRUE       | PM_Lubrication | 
| EQ002       | 2023-05-03 22:15:00    | FALSE      | CM_Belt_Break | 

This data model enables comprehensive survival analysis while maintaining the flexibility to accommodate different industrial environments and maintenance strategies.
