import dataiku
import dataikuapi
import pandas as pd

project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)
variables = project.get_variables()
accounts_dataset = dataiku.Dataset('new_molecules_scored').get_dataframe()


@app.route('/get_list')
def get_list():
    return json.dumps({"values": accounts_dataset["molecule_id"].values.tolist()})

@app.route('/get_variable')
def get_variable():
    recipe_filter = variables["local"]["molecule_filter"]
    return json.dumps({"molecule_filter": recipe_filter})


@app.route('/set_variable', methods=["POST"])
def set_variable():
    selectedRecipe = request.get_json(force=True)
    variables["local"]["molecule_filter"] = selectedRecipe["molecule_id"]
    project.set_variables(variables)
    
    return json.dumps({"molecule_filter": selectedRecipe})
    



