The **Molecular similarity** in cheminformatics refers to the degree of resemblance or likeness between two or more chemical compounds or molecules based on their structural, physicochemical, or biological properties. Assessing molecular similarity helps researchers identify structurally or functionally related compounds, which can have significant implications in applications, such as virtual screening for drug discovery, chemical toxicity prediction, and chemical library design. **Similarity measures to quantify the degree of structural similarity between molecules** usually involve two principal components: 
1. Molecular descriptors that represent the structures of the molecules being compared. 
2. Similarity coefficient (metric) used to compute a quantitative score for the degree of similarity based on the weighted values of structural descriptors. 

**Tanimoto coefficient** is a commonly used metric for computing the distance or similarity of molecules. Todeschini et al. (2013) performed a benchmarking study where they compared 51 similarity coefficients, and their result supports the Tanimoto coefficient's robustness. The equation for calculating the Tanimoto coefficient is presented below:
```S_a,b = c/[a+b+-c]``` where ```S``` represents the molecule similarity between molecules ```A``` and ```B```, ```a``` represent the number of on-bits in molecule ```A```, ```b``` represent the number of on-bits in molecule ```B``` and ```c``` represent the number of on bits in both molecules.

For the generating fingerprints **this solution** runs ``` Chem.RDKFingerprint``` in [Python](recipe:compute_molecular_similarity) that computes a hybrid fingerprint combining elements:
 1. Topological fingerprints that capture the connectivity and arrangement of atoms.
 2. Functional fingerprints focus on the presence and arrangement of specific functional groups and substructures within the molecule. 
 3. Circular fingerprints that represent the molecule as a sequence of atom types and bond types around a central molecule, encoded as a circular string.

