x_bar_creation_info = {
    "type": "chart",
    "params": {
        "engineType": "LINO",
        "refreshableSelection": {
            "selection": {
                "useMemTable": False,
                "filter": {"distinct": False, "enabled": False},
                "partitionSelectionMethod": "ALL",
                "latestPartitionsN": 1,
                "ordering": {"enabled": False, "rules": []},
                "samplingMethod": "FULL",
                "maxRecords": 10000,
                "targetRatio": 0.02,
                "ascending": True,
                "withinFirstN": -1,
                "maxReadUncompressedBytes": -1,
            },
            "autoRefreshSample": False,
            "_refreshTrigger": 0,
        },
        "def": {
            "type": "lines",
            "variant": "normal",
            "name": "X-bar - quality",
            "userEditedName": True,
            "displayWithEChartsByDefault": True,
            "genericDimension0": [
                {
                    "numParams": {"mode": "FIXED_NB", "emptyBinsMode": "ZEROS", "binSize": 1.0, "niceBounds": False, "customBinValues": [], "nbBins": 10},
                    "maxValues": 1000,
                    "generateOthersCategory": False,
                    "forceLastPositionOthers": False,
                    "oneTickPerBin": "AUTO",
                    "filters": [],
                    "isA": "dimension",
                    "sort": {"type": "NATURAL", "label": "Natural ordering", "sortAscending": True},
                    "prefix": "",
                    "suffix": "",
                    "multiplier": "Auto",
                    "hideTrailingZeros": True,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "column": "_subgroup",
                    "type": "ALPHANUM",
                }
            ],
            "genericDimension1": [],
            "facetDimension": [],
            "animationDimension": [],
            "genericMeasures": [
                {
                    "column": "UCL_Xbar_quality",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "UCL",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": False,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "LCL_Xbar_quality",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "LCL",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": False,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "mean_quality",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "decimalPlaces": 1,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": False,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "mean_quality",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
            ],
            "xDimension": [],
            "yDimension": [],
            "uaXDimension": [],
            "uaYDimension": [],
            "uaDimensionPair": [],
            "uaSize": [],
            "uaColor": [],
            "uaShape": [],
            "uaTooltip": [],
            "groupDimension": [],
            "xMeasure": [],
            "yMeasure": [],
            "colorMeasure": [],
            "sizeMeasure": [],
            "geometry": [],
            "geoLayers": [
                {
                    "geometry": [],
                    "colorOptions": {
                        "ccScaleMode": "NORMAL",
                        "paletteType": "CONTINUOUS",
                        "quantizationMode": "NONE",
                        "numQuantizeSteps": 5,
                        "paletteMiddleValue": 0.0,
                        "heatDensityMapIntensity": 0.5,
                        "heatDensityMapRadius": 0.5,
                        "singleColor": "#2678B1",
                        "transparency": 0.75,
                        "colorPalette": "default",
                        "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                        "customColors": {},
                    },
                    "uaColor": [],
                }
            ],
            "tooltipMeasures": [],
            "boxplotBreakdownDim": [],
            "boxplotValue": [],
            "filters": [],
            "xAxisFormatting": {
                "displayAxis": True,
                "showAxisTitle": True,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "axisValuesFormatting": {
                    "numberFormatting": {
                        "multiplier": "Auto",
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "",
                        "suffix": "",
                    },
                    "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                "isLogScale": False,
                "includeZero": True,
            },
            "yAxesFormatting": [
                {
                    "id": "y_left_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitle": "Mean of quality",
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": False,
                },
                {
                    "id": "y_right_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": True,
                },
            ],
            "radialAxisFormatting": {
                "showAxisTitle": False,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {},
                "isLogScale": False,
                "includeZero": True,
            },
            "smoothing": False,
            "showLegend": True,
            "strokeWidth": 5,
            "fillOpacity": 0.6,
            "tooltipOptions": {"display": True},
            "hexbinRadius": 20,
            "hexbinNumber": 20,
            "hexbinRadiusMode": "NUM_HEXAGONS",
            "valuesInChartDisplayOptions": {
                "displayValues": True,
                "displayPieLabelsOrValues": True,
                "displayMode": "LABELS",
                "overlappingStrategy": "AUTO",
                "spacing": 12,
                "placementMode": "AUTO",
                "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
            },
            "stackedColumnsOptions": {"totalsInChartDisplayOptions": {"textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False}, "addDetails": False, "additionalMeasures": []}},
            "chartHeight": 200,
            "singleXAxis": True,
            "multiTooltips": False,
            "animationFrameDuration": 3000,
            "animationRepeat": True,
            "colorMode": "UNIQUE_SCALE",
            "colorOptions": {
                "ccScaleMode": "NORMAL",
                "paletteType": "CONTINUOUS",
                "quantizationMode": "NONE",
                "numQuantizeSteps": 5,
                "paletteMiddleValue": 0.0,
                "heatDensityMapIntensity": 0.5,
                "heatDensityMapRadius": 0.5,
                "singleColor": "#2678B1",
                "transparency": 0.75,
                "colorPalette": "default",
                "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                "customColors": {"m_UCL_Xbar_quality_AVG_1": "#d62728", "m_LCL_Xbar_quality_AVG_1": "#d62728", "m_mean_quality_AVG_1": "#1f77b4"},
            },
            "colorGroups": [],
            "bubblesOptions": {"defaultRadius": 5.0, "singleShape": "FILLED_CIRCLE"},
            "computeMode": "NORMAL",
            "xAxisMode": "NORMAL",
            "yAxisMode": "NORMAL",
            "pieOptions": {"donutHoleSize": 54.0},
            "scatterZoomOptions": {"scale": [1.0, 1.0], "translate": [0.0, 0.0], "chartWidth": 0.0, "enabled": True, "persisted": True},
            "linesZoomOptions": {"displayBrush": True, "enabled": True, "persisted": True},
            "scatterOptions": {
                "equalScales": False,
                "identityLine": False,
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "regression": {
                    "show": False,
                    "displayFormula": False,
                    "type": "LINEAR",
                    "labelPosition": "INSIDE_END",
                    "lineFormatting": {"color": "#000", "size": 1},
                    "textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                },
                "numberOfRecords": 1000000.0,
            },
            "scatterMPOptions": {
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "pairColorOptions": {
                    "singleColor": "#659a88",
                    "transparency": 0.75,
                    "colorPalette": "default",
                    "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                    "customColors": {},
                },
                "numberOfRecords": 1000000.0,
            },
            "mapOptions": {"tilesLayer": "cartodb-positron", "lockSquareGrid": False},
            "mapGridOptions": {"gridLonDeg": 0.6, "gridLatDeg": 0.6},
            "radarOptions": {"filled": False, "polygonsSource": "MEASURES", "lineStyle": {"width": 2.0, "type": "SOLID"}},
            "sankeyOptions": {"curveness": 0.5, "linkColorVariant": "GRADIENT", "nodeLabelFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"}},
            "gaugeOptions": {
                "min": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "max": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "axis": {
                    "ticksConfig": {"mode": "INTERVAL"},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "thickness": 30,
                    "customRanges": False,
                },
                "displayPointer": False,
            },
            "useLiveProcessingIfAvailable": True,
            "legendPlacement": "OUTER_BOTTOM",
            "legendFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
            "pivotTableOptions": {
                "displayEmptyValues": False,
                "showSidebar": True,
                "measureDisplayMode": "ROWS",
                "displayTotals": {"subTotals": {"rows": True, "columns": True}, "grandTotal": {"row": True, "column": True}},
                "tableFormatting": {
                    "showRowHeaders": True,
                    "showRowMainHeaders": True,
                    "rowMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "freezeRowHeaders": True,
                    "showColumnHeaders": True,
                    "showColumnMainHeaders": True,
                    "columnMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "values": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "areRowsExpandedByDefault": True,
                "areColumnExpandedByDefault": True,
                "rowIdByCustomExpandedStatus": {},
                "columnIdByCustomExpandedStatus": {},
                "columnIdByCustomWidth": {},
            },
            "referenceLines": [
                {
                    "numberFormatting": {
                        "multiplier": "Inherit",
                        "decimalPlaces": 1,
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "avg.",
                        "suffix": "",
                    },
                    "labelPosition": "INSIDE_END_TOP",
                    "lineFormatting": {"type": "DASHED", "color": "#000", "size": 1},
                    "axis": {"type": "LEFT_Y_AXIS"},
                    "displayValue": True,
                    "sourceType": "AggregatedColumn",
                    "aggregatedColumn": {"column": "mean_quality", "type": "NUMERICAL", "function": "AVG", "percentile": 50.0},
                    "aggregation": "AVG",
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                }
            ],
            "gridlinesOptions": {
                "vertical": {"show": False, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
                "horizontal": {"show": False, "displayAxis": {"type": "LEFT_Y_AXIS"}, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
            },
        },
        "customMeasures": [],
        "reusableDimensions": [],
        "datasetSmartName": "selected_study_data_enhanced",
    },
    "listed": False,
    "tags": [],
    "customFields": {},
    "checklists": {"checklists": []},
}


r_chart_creation_info = {
    "type": "chart",
    "params": {
        "engineType": "LINO",
        "refreshableSelection": {
            "selection": {
                "useMemTable": False,
                "filter": {"distinct": False, "enabled": False},
                "partitionSelectionMethod": "ALL",
                "latestPartitionsN": 1,
                "ordering": {"enabled": False, "rules": []},
                "samplingMethod": "FULL",
                "maxRecords": 10000,
                "targetRatio": 0.02,
                "ascending": True,
                "withinFirstN": -1,
                "maxReadUncompressedBytes": -1,
            },
            "autoRefreshSample": False,
            "_refreshTrigger": 0,
        },
        "def": {
            "type": "lines",
            "variant": "normal",
            "name": "Copy of R - quality",
            "userEditedName": True,
            "displayWithEChartsByDefault": True,
            "genericDimension0": [
                {
                    "numParams": {"mode": "FIXED_NB", "emptyBinsMode": "ZEROS", "binSize": 1.0, "niceBounds": False, "customBinValues": [], "nbBins": 10},
                    "maxValues": 1000,
                    "generateOthersCategory": False,
                    "forceLastPositionOthers": False,
                    "oneTickPerBin": "AUTO",
                    "filters": [],
                    "isA": "dimension",
                    "sort": {"type": "NATURAL", "label": "Natural ordering", "sortAscending": True},
                    "prefix": "",
                    "suffix": "",
                    "multiplier": "Auto",
                    "hideTrailingZeros": True,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "column": "_subgroup",
                    "type": "ALPHANUM",
                }
            ],
            "genericDimension1": [],
            "facetDimension": [],
            "animationDimension": [],
            "genericMeasures": [
                {
                    "column": "UCL_R_quality",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "UCL",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": False,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "LCL_R_quality",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "LCL",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": False,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "range_quality",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "range_quality",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
            ],
            "xDimension": [],
            "yDimension": [],
            "uaXDimension": [],
            "uaYDimension": [],
            "uaDimensionPair": [],
            "uaSize": [],
            "uaColor": [],
            "uaShape": [],
            "uaTooltip": [],
            "groupDimension": [],
            "xMeasure": [],
            "yMeasure": [],
            "colorMeasure": [],
            "sizeMeasure": [],
            "geometry": [],
            "geoLayers": [
                {
                    "geometry": [],
                    "colorOptions": {
                        "ccScaleMode": "NORMAL",
                        "paletteType": "CONTINUOUS",
                        "quantizationMode": "NONE",
                        "numQuantizeSteps": 5,
                        "paletteMiddleValue": 0.0,
                        "heatDensityMapIntensity": 0.5,
                        "heatDensityMapRadius": 0.5,
                        "singleColor": "#2678B1",
                        "transparency": 0.75,
                        "colorPalette": "default",
                        "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                        "customColors": {},
                    },
                    "uaColor": [],
                }
            ],
            "tooltipMeasures": [],
            "boxplotBreakdownDim": [],
            "boxplotValue": [],
            "filters": [],
            "xAxisFormatting": {
                "displayAxis": True,
                "showAxisTitle": True,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "axisValuesFormatting": {
                    "numberFormatting": {
                        "multiplier": "Auto",
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "",
                        "suffix": "",
                    },
                    "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                "isLogScale": False,
                "includeZero": True,
            },
            "yAxesFormatting": [
                {
                    "id": "y_left_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitle": "Range of quality",
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": False,
                },
                {
                    "id": "y_right_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": True,
                },
            ],
            "radialAxisFormatting": {
                "showAxisTitle": False,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {},
                "isLogScale": False,
                "includeZero": True,
            },
            "smoothing": False,
            "showLegend": True,
            "strokeWidth": 5,
            "fillOpacity": 0.6,
            "tooltipOptions": {"display": True},
            "hexbinRadius": 20,
            "hexbinNumber": 20,
            "hexbinRadiusMode": "NUM_HEXAGONS",
            "valuesInChartDisplayOptions": {
                "displayValues": True,
                "displayPieLabelsOrValues": True,
                "displayMode": "LABELS",
                "overlappingStrategy": "AUTO",
                "spacing": 12,
                "placementMode": "AUTO",
                "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
            },
            "stackedColumnsOptions": {"totalsInChartDisplayOptions": {"textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False}, "addDetails": False, "additionalMeasures": []}},
            "chartHeight": 200,
            "singleXAxis": True,
            "multiTooltips": False,
            "animationFrameDuration": 3000,
            "animationRepeat": True,
            "colorMode": "UNIQUE_SCALE",
            "colorOptions": {
                "ccScaleMode": "NORMAL",
                "paletteType": "CONTINUOUS",
                "quantizationMode": "NONE",
                "numQuantizeSteps": 5,
                "paletteMiddleValue": 0.0,
                "heatDensityMapIntensity": 0.5,
                "heatDensityMapRadius": 0.5,
                "singleColor": "#2678B1",
                "transparency": 0.75,
                "colorPalette": "default",
                "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                "customColors": {"m_UCL_R_quality_AVG_1": "#d62728", "m_LCL_R_quality_AVG_1": "#d62728", "m_range_quality_AVG_1": "#8c564b"},
            },
            "colorGroups": [],
            "bubblesOptions": {"defaultRadius": 5.0, "singleShape": "FILLED_CIRCLE"},
            "computeMode": "NORMAL",
            "xAxisMode": "NORMAL",
            "yAxisMode": "NORMAL",
            "pieOptions": {"donutHoleSize": 54.0},
            "scatterZoomOptions": {"scale": [1.0, 1.0], "translate": [0.0, 0.0], "chartWidth": 0.0, "enabled": True, "persisted": True},
            "linesZoomOptions": {"displayBrush": True, "enabled": True, "persisted": True},
            "scatterOptions": {
                "equalScales": False,
                "identityLine": False,
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "regression": {
                    "show": False,
                    "displayFormula": False,
                    "type": "LINEAR",
                    "labelPosition": "INSIDE_END",
                    "lineFormatting": {"color": "#000", "size": 1},
                    "textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                },
                "numberOfRecords": 1000000.0,
            },
            "scatterMPOptions": {
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "pairColorOptions": {
                    "singleColor": "#659a88",
                    "transparency": 0.75,
                    "colorPalette": "default",
                    "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                    "customColors": {},
                },
                "numberOfRecords": 1000000.0,
            },
            "mapOptions": {"tilesLayer": "cartodb-positron", "lockSquareGrid": False},
            "mapGridOptions": {"gridLonDeg": 0.6, "gridLatDeg": 0.6},
            "radarOptions": {"filled": False, "polygonsSource": "MEASURES", "lineStyle": {"width": 2.0, "type": "SOLID"}},
            "sankeyOptions": {"curveness": 0.5, "linkColorVariant": "GRADIENT", "nodeLabelFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"}},
            "gaugeOptions": {
                "min": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "max": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "axis": {
                    "ticksConfig": {"mode": "INTERVAL"},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "thickness": 30,
                    "customRanges": False,
                },
                "displayPointer": False,
            },
            "useLiveProcessingIfAvailable": True,
            "legendPlacement": "OUTER_BOTTOM",
            "legendFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
            "pivotTableOptions": {
                "displayEmptyValues": False,
                "showSidebar": True,
                "measureDisplayMode": "ROWS",
                "displayTotals": {"subTotals": {"rows": True, "columns": True}, "grandTotal": {"row": True, "column": True}},
                "tableFormatting": {
                    "showRowHeaders": True,
                    "showRowMainHeaders": True,
                    "rowMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "freezeRowHeaders": True,
                    "showColumnHeaders": True,
                    "showColumnMainHeaders": True,
                    "columnMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "values": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "areRowsExpandedByDefault": True,
                "areColumnExpandedByDefault": True,
                "rowIdByCustomExpandedStatus": {},
                "columnIdByCustomExpandedStatus": {},
                "columnIdByCustomWidth": {},
            },
            "referenceLines": [
                {
                    "numberFormatting": {
                        "multiplier": "Inherit",
                        "decimalPlaces": 1,
                        "hideTrailingZeros": False,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "avg. ",
                        "suffix": "",
                    },
                    "labelPosition": "INSIDE_END_TOP",
                    "lineFormatting": {"type": "DASHED", "color": "#000", "size": 1},
                    "axis": {"type": "LEFT_Y_AXIS"},
                    "displayValue": True,
                    "sourceType": "AggregatedColumn",
                    "aggregatedColumn": {"column": "range_quality", "type": "NUMERICAL", "function": "AVG", "percentile": 50.0},
                    "aggregation": "AVG",
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                }
            ],
            "gridlinesOptions": {
                "vertical": {"show": False, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
                "horizontal": {"show": False, "displayAxis": {"type": "LEFT_Y_AXIS"}, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
            },
        },
        "customMeasures": [],
        "reusableDimensions": [],
        "datasetSmartName": "selected_study_data_enhanced",
    },
    "listed": False,
}

dist_plot_creation_info = {
    "type": "chart",
    "params": {
        "engineType": "LINO",
        "refreshableSelection": {
            "selection": {
                "useMemTable": False,
                "filter": {"distinct": False, "enabled": False},
                "partitionSelectionMethod": "ALL",
                "latestPartitionsN": 1,
                "ordering": {"enabled": False, "rules": []},
                "samplingMethod": "FULL",
                "maxRecords": 10000,
                "targetRatio": 0.02,
                "ascending": True,
                "withinFirstN": -1,
                "maxReadUncompressedBytes": -1,
            },
            "autoRefreshSample": False,
            "_refreshTrigger": 0,
        },
        "def": {
            "type": "multi_columns_lines",
            "variant": "normal",
            "name": "Copy of Count by quality",
            "userEditedName": True,
            "displayWithEChartsByDefault": True,
            "genericDimension0": [
                {
                    "numParams": {"mode": "FIXED_NB", "emptyBinsMode": "ZEROS", "binSize": 100.0, "niceBounds": False, "customBinValues": [], "nbBins": 30},
                    "maxValues": 1000,
                    "generateOthersCategory": True,
                    "forceLastPositionOthers": False,
                    "oneTickPerBin": "AUTO",
                    "filters": [],
                    "isA": "dimension",
                    "prefix": "",
                    "suffix": "",
                    "multiplier": "Auto",
                    "hideTrailingZeros": True,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "column": "quality",
                    "type": "NUMERICAL",
                }
            ],
            "genericDimension1": [],
            "facetDimension": [],
            "animationDimension": [],
            "genericMeasures": [
                {
                    "function": "COUNT",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "norm_distribution_curve_quality",
                    "function": "CUSTOM",
                    "type": "CUSTOM",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis2",
                    "displayType": "line",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": True,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "customFunction": "avg((1/(sqrt(2*PI())*${std_quality}))*exp(-1*(pow(quality-${mean_quality},2)/(2*pow(${std_quality},2)))))",
                    "inferredType": "NUMERICAL",
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
            ],
            "xDimension": [],
            "yDimension": [],
            "uaXDimension": [],
            "uaYDimension": [],
            "uaDimensionPair": [],
            "uaSize": [],
            "uaColor": [],
            "uaShape": [],
            "uaTooltip": [],
            "groupDimension": [],
            "xMeasure": [],
            "yMeasure": [],
            "colorMeasure": [],
            "sizeMeasure": [],
            "geometry": [],
            "geoLayers": [
                {
                    "geometry": [],
                    "colorOptions": {
                        "ccScaleMode": "NORMAL",
                        "paletteType": "CONTINUOUS",
                        "quantizationMode": "NONE",
                        "numQuantizeSteps": 5,
                        "paletteMiddleValue": 0.0,
                        "heatDensityMapIntensity": 0.5,
                        "heatDensityMapRadius": 0.5,
                        "singleColor": "#2678B1",
                        "transparency": 0.75,
                        "colorPalette": "default",
                        "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                        "customColors": {},
                    },
                    "uaColor": [],
                }
            ],
            "tooltipMeasures": [],
            "boxplotBreakdownDim": [],
            "boxplotValue": [],
            "filters": [],
            "xAxisFormatting": {
                "displayAxis": True,
                "showAxisTitle": True,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "axisValuesFormatting": {
                    "numberFormatting": {
                        "multiplier": "Auto",
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "",
                        "suffix": "",
                    },
                    "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                "isLogScale": False,
                "includeZero": True,
            },
            "yAxesFormatting": [
                {
                    "id": "y_left_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": True,
                },
                {
                    "id": "y_right_0",
                    "displayAxis": False,
                    "showAxisTitle": False,
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": True,
                },
            ],
            "radialAxisFormatting": {
                "showAxisTitle": False,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {},
                "isLogScale": False,
                "includeZero": True,
            },
            "smoothing": True,
            "showLegend": True,
            "strokeWidth": 4,
            "fillOpacity": 0.6,
            "tooltipOptions": {"display": True},
            "hexbinRadius": 20,
            "hexbinNumber": 20,
            "hexbinRadiusMode": "NUM_HEXAGONS",
            "valuesInChartDisplayOptions": {
                "displayValues": False,
                "displayPieLabelsOrValues": True,
                "displayMode": "LABELS",
                "overlappingStrategy": "AUTO",
                "spacing": 5,
                "placementMode": "AUTO",
                "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
            },
            "stackedColumnsOptions": {"totalsInChartDisplayOptions": {"textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False}, "addDetails": False, "additionalMeasures": []}},
            "chartHeight": 200,
            "singleXAxis": True,
            "multiTooltips": False,
            "animationFrameDuration": 3000,
            "animationRepeat": True,
            "colorMode": "UNIQUE_SCALE",
            "colorOptions": {
                "ccScaleMode": "NORMAL",
                "paletteType": "CONTINUOUS",
                "quantizationMode": "NONE",
                "numQuantizeSteps": 5,
                "paletteMiddleValue": 0.0,
                "heatDensityMapIntensity": 0.5,
                "heatDensityMapRadius": 0.5,
                "singleColor": "#2678B1",
                "transparency": 0.75,
                "colorPalette": "default",
                "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                "customColors": {"m_null_COUNT_1": "#1f77b4", "m_distribution_curve_CUSTOM_1": "#2ca02c"},
            },
            "colorGroups": [],
            "bubblesOptions": {"defaultRadius": 5.0, "singleShape": "FILLED_CIRCLE"},
            "computeMode": "NORMAL",
            "xAxisMode": "NORMAL",
            "yAxisMode": "NORMAL",
            "pieOptions": {"donutHoleSize": 54.0},
            "scatterZoomOptions": {"scale": [1.0, 1.0], "translate": [0.0, 0.0], "chartWidth": 0.0, "enabled": True, "persisted": True},
            "linesZoomOptions": {"displayBrush": True, "enabled": True, "persisted": True},
            "scatterOptions": {
                "equalScales": False,
                "identityLine": False,
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "regression": {
                    "show": False,
                    "displayFormula": False,
                    "type": "LINEAR",
                    "labelPosition": "INSIDE_END",
                    "lineFormatting": {"color": "#000", "size": 1},
                    "textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                },
                "numberOfRecords": 1000000.0,
            },
            "scatterMPOptions": {
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "pairColorOptions": {
                    "singleColor": "#659a88",
                    "transparency": 0.75,
                    "colorPalette": "default",
                    "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                    "customColors": {},
                },
                "numberOfRecords": 1000000.0,
            },
            "mapOptions": {"tilesLayer": "cartodb-positron", "lockSquareGrid": False},
            "mapGridOptions": {"gridLonDeg": 0.5, "gridLatDeg": 0.5},
            "radarOptions": {"filled": False, "polygonsSource": "MEASURES", "lineStyle": {"width": 2.0, "type": "SOLID"}},
            "sankeyOptions": {"curveness": 0.5, "linkColorVariant": "GRADIENT", "nodeLabelFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"}},
            "gaugeOptions": {
                "min": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "max": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "axis": {
                    "ticksConfig": {"mode": "INTERVAL"},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "thickness": 30,
                    "customRanges": False,
                },
                "displayPointer": False,
            },
            "useLiveProcessingIfAvailable": True,
            "legendPlacement": "OUTER_BOTTOM",
            "legendFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
            "pivotTableOptions": {
                "displayEmptyValues": False,
                "showSidebar": True,
                "measureDisplayMode": "ROWS",
                "displayTotals": {"subTotals": {"rows": True, "columns": True}, "grandTotal": {"row": True, "column": True}},
                "tableFormatting": {
                    "showRowHeaders": True,
                    "showRowMainHeaders": True,
                    "rowMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "freezeRowHeaders": True,
                    "showColumnHeaders": True,
                    "showColumnMainHeaders": True,
                    "columnMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "values": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "areRowsExpandedByDefault": True,
                "areColumnExpandedByDefault": True,
                "rowIdByCustomExpandedStatus": {},
                "columnIdByCustomExpandedStatus": {},
                "columnIdByCustomWidth": {},
            },
            "referenceLines": [
                {
                    "numberFormatting": {
                        "multiplier": "Inherit",
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "USL: ",
                        "suffix": "",
                    },
                    "labelPosition": "INSIDE_START_TOP",
                    "lineFormatting": {"type": "DASHED", "color": "#d62728", "size": 3},
                    "axis": {"type": "X_AXIS"},
                    "displayValue": True,
                    "valueFormatting": {"fontSize": 16, "fontColor": "#333", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                    "sourceType": "DatasetColumn",
                    "datasetColumn": {"column": "USL_quality", "type": "NUMERICAL", "percentile": 50.0},
                    "aggregation": "MAX",
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                {
                    "numberFormatting": {
                        "multiplier": "Inherit",
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "LSL:  ",
                        "suffix": "",
                    },
                    "labelPosition": "INSIDE_END_TOP",
                    "lineFormatting": {"type": "DASHED", "color": "#d62728", "size": 3},
                    "axis": {"type": "X_AXIS"},
                    "displayValue": True,
                    "valueFormatting": {"fontSize": 16, "fontColor": "#333", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                    "sourceType": "DatasetColumn",
                    "datasetColumn": {"column": "LSL_quality", "type": "NUMERICAL", "percentile": 50.0},
                    "aggregation": "MAX",
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
            ],
            "gridlinesOptions": {
                "vertical": {"show": False, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
                "horizontal": {"show": True, "displayAxis": {"type": "LEFT_Y_AXIS"}, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
            },
        },
        "reusableDimensions": [],
        "datasetSmartName": "process_capability_visualization",
    },
    "listed": False,
    "tags": [],
    "customFields": {},
    "checklists": {"checklists": []},
}

cpk_table_creation_info = {
    "type": "dataset_table",
    "params": {
        "shakerScript": {
            "steps": [],
            "maxProcessedMemTableBytes": -1,
            "columnsSelection": {
                "mode": "ALL",
                "list": [
                    {"name": "Cpk", "d": True},
                    {"name": "Sigma Level (σ)", "d": True},
                    {"name": "% Conforming", "d": True},
                    {"name": "Out of spec per million", "d": True},
                    {"name": "Out of spec rate", "d": True},
                ],
            },
            "columnOrder": [],
            "columnWidthsByName": {"Cpk": 60, "Sigma Level (σ)": 117, "% Conforming": 111, "Out of spec per million": 159, "Out of spec rate": 125},
            "columnUseScientificNotationByName": {},
            "coloring": {"scheme": "MEANING_AND_STATUS", "individualColumns": [], "individualColumnsRules": [], "valueColoringMode": "HASH", "coloringGroups": []},
            "sorting": [],
            "analysisColumnData": {},
            "explorationSampling": {
                "selection": {
                    "maxRecordsForDisplay": -1,
                    "maxStoredBytes": 268435456,
                    "timeout": -1,
                    "filter": {"distinct": False, "enabled": False},
                    "partitionSelectionMethod": "ALL",
                    "latestPartitionsN": 1,
                    "ordering": {"enabled": False, "rules": []},
                    "samplingMethod": "FULL",
                    "maxRecords": 10000,
                    "targetRatio": 0.02,
                    "ascending": True,
                    "withinFirstN": -1,
                    "maxReadUncompressedBytes": -1,
                },
                "autoRefreshSample": False,
                "_refreshTrigger": 0,
            },
            "vizSampling": {
                "selection": {
                    "useMemTable": False,
                    "filter": {"distinct": False, "enabled": False},
                    "partitionSelectionMethod": "ALL",
                    "latestPartitionsN": 1,
                    "ordering": {"enabled": False, "rules": []},
                    "samplingMethod": "FULL",
                    "maxRecords": -1,
                    "targetRatio": 0.02,
                    "ascending": True,
                    "withinFirstN": -1,
                    "maxReadUncompressedBytes": -1,
                },
                "autoRefreshSample": False,
                "_refreshTrigger": 0,
            },
            "exploreUIParams": {"autoRefresh": True},
            "globalSearchQuery": "",
            "explorationFilters": [],
            "previewMode": "ALL_ROWS",
        },
        "datasetSmartName": "cpk_table",
    },
    "owner": "romain.menini@dataiku.com",
    "listed": False,
    "name": "cpk_table table",
    "tags": [],
    "customFields": {},
    "checklists": {"checklists": []},
}

metrics_creation_info = {
    "type": "chart",
    "params": {
        "engineType": "LINO",
        "refreshableSelection": {
            "selection": {
                "useMemTable": False,
                "filter": {"distinct": False, "enabled": False},
                "partitionSelectionMethod": "ALL",
                "latestPartitionsN": 1,
                "ordering": {"enabled": False, "rules": []},
                "samplingMethod": "FULL",
                "maxRecords": 10000,
                "targetRatio": 0.02,
                "ascending": True,
                "withinFirstN": -1,
                "maxReadUncompressedBytes": -1,
            },
            "autoRefreshSample": False,
            "_refreshTrigger": 0,
        },
        "def": {
            "type": "kpi",
            "variant": "normal",
            "userEditedName": True,
            "displayWithEChartsByDefault": True,
            "genericDimension0": [],
            "genericDimension1": [],
            "facetDimension": [],
            "animationDimension": [],
            "genericMeasures": [
                {
                    "column": "T_data_3_2_cp",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "decimalPlaces": 2,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": False,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "cp",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "T_data_3_2_cpk",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "decimalPlaces": 2,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": False,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "cpk",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "T_data_3_2_cpm",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "decimalPlaces": 2,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": False,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "cpm",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
                {
                    "column": "T_data_3_2_cpkm",
                    "function": "AVG",
                    "type": "NUMERICAL",
                    "displayed": True,
                    "isA": "measure",
                    "displayAxis": "axis1",
                    "displayType": "column",
                    "computeMode": "NORMAL",
                    "computeModeDim": 0,
                    "multiplier": "Auto",
                    "decimalPlaces": 2,
                    "digitGrouping": "DEFAULT",
                    "useParenthesesForNegativeValues": False,
                    "shouldFormatInPercentage": False,
                    "hideTrailingZeros": False,
                    "prefix": "",
                    "suffix": "",
                    "showValue": True,
                    "displayLabel": "cpkm",
                    "showDisplayLabel": True,
                    "labelPosition": "BOTTOM",
                    "labelFontSize": 16,
                    "percentile": 50.0,
                    "isCustomPercentile": False,
                    "kpiTextAlign": "CENTER",
                    "kpiValueFontSizeMode": "RESPONSIVE",
                    "kpiValueFontSize": 32,
                    "responsiveTextAreaFill": 100,
                    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
                    "valuesInChartDisplayOptions": {
                        "displayValues": True,
                        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                        "addDetails": False,
                        "additionalMeasures": [],
                    },
                    "colorRules": [],
                },
            ],
            "xDimension": [],
            "yDimension": [],
            "uaXDimension": [],
            "uaYDimension": [],
            "uaDimensionPair": [],
            "uaSize": [],
            "uaColor": [],
            "uaShape": [],
            "uaTooltip": [],
            "groupDimension": [],
            "xMeasure": [],
            "yMeasure": [],
            "colorMeasure": [],
            "sizeMeasure": [],
            "geometry": [],
            "geoLayers": [
                {
                    "geometry": [],
                    "colorOptions": {
                        "ccScaleMode": "NORMAL",
                        "paletteType": "CONTINUOUS",
                        "quantizationMode": "NONE",
                        "numQuantizeSteps": 5,
                        "paletteMiddleValue": 0.0,
                        "heatDensityMapIntensity": 0.5,
                        "heatDensityMapRadius": 0.5,
                        "singleColor": "#2678B1",
                        "transparency": 0.75,
                        "colorPalette": "default",
                        "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                        "customColors": {},
                    },
                    "uaColor": [],
                }
            ],
            "tooltipMeasures": [],
            "boxplotBreakdownDim": [],
            "boxplotValue": [],
            "filters": [],
            "xAxisFormatting": {
                "displayAxis": True,
                "showAxisTitle": True,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "axisValuesFormatting": {
                    "numberFormatting": {
                        "multiplier": "Auto",
                        "hideTrailingZeros": True,
                        "digitGrouping": "DEFAULT",
                        "useParenthesesForNegativeValues": False,
                        "shouldFormatInPercentage": False,
                        "prefix": "",
                        "suffix": "",
                    },
                    "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                "isLogScale": False,
                "includeZero": True,
            },
            "yAxesFormatting": [
                {
                    "id": "y_left_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": True,
                },
                {
                    "id": "y_right_0",
                    "displayAxis": True,
                    "showAxisTitle": True,
                    "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "ticksConfig": {"mode": "INTERVAL"},
                    "customExtent": {"editMode": "AUTO", "manualExtent": [None, None]},
                    "isLogScale": False,
                    "includeZero": True,
                },
            ],
            "radialAxisFormatting": {
                "showAxisTitle": False,
                "axisTitleFormatting": {"fontSize": 15, "fontColor": "#333", "hasBackground": False},
                "ticksConfig": {"mode": "INTERVAL"},
                "customExtent": {},
                "isLogScale": False,
                "includeZero": True,
            },
            "smoothing": True,
            "showLegend": True,
            "strokeWidth": 2,
            "fillOpacity": 0.6,
            "tooltipOptions": {"display": True},
            "hexbinRadius": 20,
            "hexbinNumber": 20,
            "hexbinRadiusMode": "NUM_HEXAGONS",
            "valuesInChartDisplayOptions": {
                "displayValues": False,
                "displayPieLabelsOrValues": True,
                "displayMode": "LABELS",
                "overlappingStrategy": "AUTO",
                "placementMode": "AUTO",
                "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
            },
            "stackedColumnsOptions": {"totalsInChartDisplayOptions": {"textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False}, "addDetails": False, "additionalMeasures": []}},
            "chartHeight": 200,
            "singleXAxis": True,
            "multiTooltips": False,
            "animationFrameDuration": 3000,
            "animationRepeat": True,
            "colorMode": "COLOR_GROUPS",
            "colorOptions": {
                "ccScaleMode": "NORMAL",
                "paletteType": "CONTINUOUS",
                "quantizationMode": "NONE",
                "numQuantizeSteps": 5,
                "paletteMiddleValue": 0.0,
                "heatDensityMapIntensity": 0.5,
                "heatDensityMapRadius": 0.5,
                "singleColor": "#2678B1",
                "transparency": 0.75,
                "colorPalette": "default",
                "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                "customColors": {},
            },
            "colorGroups": [],
            "bubblesOptions": {"defaultRadius": 5.0, "singleShape": "FILLED_CIRCLE"},
            "computeMode": "NORMAL",
            "xAxisMode": "NORMAL",
            "yAxisMode": "NORMAL",
            "pieOptions": {"donutHoleSize": 54.0},
            "scatterZoomOptions": {"scale": [1.0, 1.0], "translate": [0.0, 0.0], "chartWidth": 0.0, "enabled": True, "persisted": True},
            "linesZoomOptions": {"displayBrush": True, "enabled": True, "persisted": True},
            "scatterOptions": {
                "equalScales": False,
                "identityLine": False,
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "regression": {
                    "show": False,
                    "displayFormula": False,
                    "type": "LINEAR",
                    "labelPosition": "INSIDE_END",
                    "lineFormatting": {"color": "#000", "size": 1},
                    "textFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
                },
                "numberOfRecords": 1000000.0,
            },
            "scatterMPOptions": {
                "connectPoints": {"enabled": False, "splitBy": "COLOR", "lineFormatting": {"color": "#000", "size": 1}},
                "optimizeRendering": False,
                "pairColorOptions": {
                    "singleColor": "#659a88",
                    "transparency": 0.75,
                    "colorPalette": "default",
                    "customPalette": {"id": "__dku_custom__", "name": "Custom Palette", "colors": [], "values": [], "fixedValues": False},
                    "customColors": {},
                },
                "numberOfRecords": 1000000.0,
            },
            "mapOptions": {"tilesLayer": "cartodb-positron", "lockSquareGrid": False},
            "mapGridOptions": {"gridLonDeg": 0.5, "gridLatDeg": 0.5},
            "radarOptions": {"filled": False, "polygonsSource": "MEASURES", "lineStyle": {"width": 2.0, "type": "SOLID"}},
            "sankeyOptions": {"curveness": 0.5, "linkColorVariant": "GRADIENT", "nodeLabelFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"}},
            "gaugeOptions": {
                "min": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "max": {
                    "sourceType": "Constant",
                    "percentile": 0.0,
                    "isCustomPercentile": False,
                    "constantValue": 0.0,
                    "constantDateValue": 0.0,
                    "defaultConstantValue": 0.0,
                    "ignoreExistingFilters": False,
                },
                "axis": {
                    "ticksConfig": {"mode": "INTERVAL"},
                    "axisValuesFormatting": {
                        "numberFormatting": {
                            "multiplier": "Auto",
                            "hideTrailingZeros": True,
                            "digitGrouping": "DEFAULT",
                            "useParenthesesForNegativeValues": False,
                            "shouldFormatInPercentage": False,
                            "prefix": "",
                            "suffix": "",
                        },
                        "axisTicksFormatting": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    },
                    "thickness": 30,
                    "customRanges": False,
                },
                "displayPointer": False,
            },
            "useLiveProcessingIfAvailable": True,
            "legendPlacement": "OUTER_BOTTOM",
            "legendFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
            "pivotTableOptions": {
                "displayEmptyValues": False,
                "showSidebar": True,
                "measureDisplayMode": "ROWS",
                "displayTotals": {"subTotals": {"rows": True, "columns": True}, "grandTotal": {"row": True, "column": True}},
                "tableFormatting": {
                    "showRowHeaders": True,
                    "showRowMainHeaders": True,
                    "rowMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "freezeRowHeaders": True,
                    "showColumnHeaders": True,
                    "showColumnMainHeaders": True,
                    "columnMainHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnSubheaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "values": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "rowHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                    "columnHeaders": {"fontSize": 12, "fontColor": "#333", "hasBackground": False},
                },
                "areRowsExpandedByDefault": True,
                "areColumnExpandedByDefault": True,
                "rowIdByCustomExpandedStatus": {},
                "columnIdByCustomExpandedStatus": {},
                "columnIdByCustomWidth": {},
            },
            "gridlinesOptions": {
                "vertical": {"show": False, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
                "horizontal": {"show": True, "displayAxis": {"type": "LEFT_Y_AXIS"}, "lineFormatting": {"type": "FILLED", "color": "#d9d9d9", "size": 1}},
            },
        },
        "customMeasures": [],
        "reusableDimensions": [],
        "datasetSmartName": "capability_metrics",
    },
    "tags": [],
    "customFields": {},
    "checklists": {"checklists": []},
}

dist_plot_generic_measures_template = [
    {
        "function": "COUNT",
        "type": "NUMERICAL",
        "displayed": True,
        "isA": "measure",
        "displayAxis": "axis1",
        "displayType": "column",
        "computeMode": "NORMAL",
        "computeModeDim": 0,
        "multiplier": "Auto",
        "digitGrouping": "DEFAULT",
        "useParenthesesForNegativeValues": False,
        "shouldFormatInPercentage": False,
        "hideTrailingZeros": True,
        "prefix": "",
        "suffix": "",
        "showValue": True,
        "showDisplayLabel": True,
        "labelPosition": "BOTTOM",
        "labelFontSize": 16,
        "percentile": 50.0,
        "isCustomPercentile": False,
        "kpiTextAlign": "CENTER",
        "kpiValueFontSizeMode": "RESPONSIVE",
        "kpiValueFontSize": 32,
        "responsiveTextAreaFill": 100,
        "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
        "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
        "valuesInChartDisplayOptions": {
            "displayValues": True,
            "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
            "addDetails": False,
            "additionalMeasures": [],
        },
        "colorRules": [],
        "column": "__COLUMN__",  # placeholder
    },
    {
        "function": "CUSTOM",
        "type": "CUSTOM",
        "displayed": True,
        "isA": "measure",
        "displayAxis": "axis2",
        "displayType": "line",
        "computeMode": "NORMAL",
        "computeModeDim": 0,
        "multiplier": "Auto",
        "digitGrouping": "DEFAULT",
        "useParenthesesForNegativeValues": False,
        "shouldFormatInPercentage": False,
        "hideTrailingZeros": True,
        "prefix": "",
        "suffix": "",
        "showValue": True,
        "showDisplayLabel": True,
        "labelPosition": "BOTTOM",
        "labelFontSize": 16,
        "customFunction": "__CUSTOM_FUNCTION__",  # placeholder
        "inferredType": "NUMERICAL",
        "percentile": 50.0,
        "isCustomPercentile": False,
        "kpiTextAlign": "CENTER",
        "kpiValueFontSizeMode": "RESPONSIVE",
        "kpiValueFontSize": 32,
        "responsiveTextAreaFill": 100,
        "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
        "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
        "valuesInChartDisplayOptions": {
            "displayValues": True,
            "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
            "addDetails": False,
            "additionalMeasures": [],
        },
        "colorRules": [],
        "column": "__CUSTOM_COLUMN__",  # placeholder
    },
]

generic_measure_template = {
    "function": "AVG",
    "type": "NUMERICAL",
    "displayed": True,
    "isA": "measure",
    "displayAxis": "axis1",
    "displayType": "column",
    "computeMode": "NORMAL",
    "computeModeDim": 0,
    "multiplier": "Auto",
    "digitGrouping": "DEFAULT",
    "useParenthesesForNegativeValues": False,
    "shouldFormatInPercentage": False,
    "hideTrailingZeros": True,
    "prefix": "",
    "suffix": "",
    "showValue": True,
    "showDisplayLabel": True,
    "labelPosition": "BOTTOM",
    "labelFontSize": 16,
    "percentile": 50.0,
    "isCustomPercentile": False,
    "kpiTextAlign": "CENTER",
    "kpiValueFontSizeMode": "RESPONSIVE",
    "kpiValueFontSize": 32,
    "responsiveTextAreaFill": 100,
    "valueTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
    "labelTextFormatting": {"fontSize": 11, "fontColor": "#333", "hasBackground": False},
    "valuesInChartDisplayOptions": {
        "displayValues": True,
        "textFormatting": {"fontSize": 11, "fontColor": "AUTO", "hasBackground": False, "backgroundColor": "#D9D9D9BF"},
        "addDetails": False,
        "additionalMeasures": [],
    },
    "colorRules": [],
    "column": "",  # <-- Will be set later
}

target_line = {
    "numberFormatting": {
        "multiplier": "Inherit",
        "hideTrailingZeros": True,
        "digitGrouping": "DEFAULT",
        "useParenthesesForNegativeValues": False,
        "shouldFormatInPercentage": False,
        "prefix": "target: ",
        "suffix": "",
    },
    "labelPosition": "INSIDE_END_TOP",
    "lineFormatting": {"type": "FILLED", "color": "#000000", "size": 3},
    "axis": {"type": "X_AXIS"},
    "displayValue": True,
    "valueFormatting": {"fontSize": 16, "fontColor": "#333", "hasBackground": True, "backgroundColor": "#BFBFBFBF"},
    "sourceType": "Constant",
    "aggregation": "MAX",
    "percentile": 50.0,
    "isCustomPercentile": False,
    "constantValue": 450.0,
    "constantDateValue": 0.0,
    "defaultConstantValue": 0.0,
    "ignoreExistingFilters": False,
}

dashboard_first_page = {
    "grid": {
        "tiles": [
            {
                "tileType": "TEXT",
                "box": {"top": 0, "left": 0, "width": 27, "height": 3},
                "clickAction": "DO_NOTHING",
                "tileParams": {
                    "text": "Compare selected parameters alongside target variable to confirm whether zone identified with parameters analyzer results in desired effect.\n - upper/lower zone: parameter range as defined in parameter analyzer saved study\n - upper/lower limit: target variable OK/not-OK range as defined in parameter analyzer saved study\n - r coefficient: correlation between given parameter and target variable, as additional information",
                    "textAlign": "LEFT",
                    "verticalAlign": "TOP",
                },
                "backgroundOpacity": 1.0,
                "backgroundColor": "#ffffff",
                "autoLoad": True,
                "locked": False,
                "borderOptions": {"color": "#D9D9D9", "radius": 0, "size": 1},
                "titleOptions": {"showTitle": "NO", "fontColor": "#000", "fontSize": 13},
                "displayMode": "INSIGHT",
                "useDashboardSpacing": True,
                "tileSpacing": 8,
                "padding": 0,
                "resizeImageMode": "FIT_SIZE",
            }
        ]
    },
    "title": "Monitor Parameter Change Experiments",
    "show": True,
    "showTitle": True,
    "titleAlign": "CENTER",
    "titleFontColor": "#444444",
    "titleFontSize": 28,
    "enableCrossFilters": True,
    "backgroundColor": "#ffffff",
    "showFilterPanel": True,
}
