This case study offers a walkthrough of the Solution using an example dataset from a simple manufacturing process. We will use the Solution to determine if the process and target parameters are under statistical control when run at specific identified set points, and what the corresponding capability metrics are.

# User Story
Using [Parameters Analyzer](https://www.dataiku.com/solutions/catalog/parameters-analyzer/), we determined that several of the process parameters have a substantial impact on the target value, and what ranges of these parameters tend to result in a better value of the target parameter (quality). We now want to investigate if the process is under statistical control while operating in these preferred ranges. Thus, we set up an experiment / trail run in which we collect measurements of the process, while the parameters are given setpoints within the identified ranges. Now we want to conduct a classical capability study on the experimental process data to see if the process is under statistical control when run with these specific settings.

## SPC theory
For those not familiar with control charts, here is a brief summary of the concepts used in this Solution:

Control charts are statistical tools that graphically display process data over time, helping to distinguish between **common cause** (natural) variation and **special cause** (unusual) variation. Each chart has a **central line** (process average) and **upper and lower control limits** (calculated from the experiment data, using the number of standard deviations specified) that define the expected range of variation. Data is often collected in **subgroups**—small, consecutive samples taken under consistent conditions—which allows for the monitoring of both within-subgroup and between-subgroup variation. Points falling outside the limits or showing non-random patterns indicate an  **"out of control"**  process, signaling a need for investigation and corrective action, thus enabling continuous monitoring and improvement of process stability. If the process is in control, the  **capability metrics**  will be calculated on the next page of the dashboard.
![control_charts_example.png](9MbERDrnemhG)

The upper- and lower control limits (UCL and LCL) are automatically calculated by the Solution using the standard subgroup-size-specific anti-biasing constants tables:
![control_chart_constants_1.png](qzdAvV776Ajr)
![control_chart_constants_2.png](enrIbj05KbHf)
Source: [Institute of Quality and Reliability](https://web.mit.edu/2.810/www/files/readings/ControlChartConstantsAndFormulae.pdf) 

The Solution calculates, were applicable, the following process capability indices:
![control_charts_capability_indices.png](tmk5C5PwOK3x)
Source: [Wikipedia](https://en.wikipedia.org/wiki/Process_capability_index)

### Types of control charts
There are three types of control charts, differentiated by the subgroup size used.

1.  **I-MR  (Individuals and Moving Range) Chart**
  - _What it is_:
        - I (Individuals) Chart: Plots individual data points. It monitors the process center (average).
       - MR (Moving Range) Chart: Plots the range (difference) between two consecutive data points. It monitors the process variation (spread).
  - _When to Use:_  Use this chart when your subgroup size is 1. Typically used when the process is continuous, and taking distinct subgroups does not make sense (e.g., the temperature of a chemical batch). Or when data is expensive or slow to collect (e.g. results from a destructive test). 

2.  **X̅-R (Average and Range) Chart** 
 -  _What it is:_ 
      - X̅ (Average) Chart: Plots the average of each subgroup. It monitors the process center.
      - R (Range) Chart: Plots the range (Max - Min) within each subgroup. It monitors the process variation.
 -  _When to Use:_  This is the most common chart for variable data. It is used when you collect data in small subgroups, typically with a size of 2 to 10.

3.  **X̅-S (Average and Standard Deviation) Chart** 
 -  _What it is:_ 
      - X̅ (Average) Chart: Plots the average of each subgroup. It monitors the process center.
      - S (Standard Deviation) Chart: Plots the standard deviation within each subgroup. It monitors the process variation.
 -  _When to Use:_  Use this chart when you collect data in moderate to large subgroups, typically greater than 10. For larger subgroups, the standard deviation is a more statistically accurate and stable measure of variation than the range. The range becomes unreliable as subgroup size increases because it only uses two data points (the highest and lowest) and ignores all the data in between.


# Data
Our experiment dataset contains sensor readings from a coffee bean roasting process. 
The specific process parameters we are interested in are selected temperature settings across the roasting process:
- ```T_data_1_1```
- ```T_data_2_1```
- ```T_data_3_1```

And the aforementioned target parameter:
- ```quality```

See [Data Model](article:10) for details on the data input requirements of the Manufacturing Process Control Solution.

# Insights
Firstly, the Solution will generate control charts from which we can tell which process parameters are under control.  
Secondly, the Solution will calculate capability metrics for the investigated parameters that are under control, so that we know exactly how capable the process is for a given parameter, to then see if this fulfills the quality requirements of our company. 