# Overview

This Solution relies on three scenarios to automate the SPC analysis flow.  
Each scenario covers a distinct stage of the process — from preparing uploaded files or connected datasets, to importing study configurations from Parameters Analyzer, and finally generating the SPC charts and metrics.  

Together, they ensure that data is consistently prepared, parameters are correctly applied, and dashboards are always up to date with the latest analysis.

# Scenario: File Upload

[This scenario](scenario:FILEUPLOAD) is used when the user uploads CSV files into the Solution. It prepares the uploaded data, adapts connections, and configures the application variables so the analysis can be launched seamlessly.

## Key Steps:

1. **Connect the uploaded dataset**  
   Ensures the dataset provided by the user (`uploaded_experiment_dataset`) is connected in the flow. If it is not already linked, it is plugged into the `compute_experiment_dataset` recipe.

2. **Change connection & engines**  
   Adjusts dataset connections and recipe execution engines to align with the project’s default configuration. This step guarantees that uploaded data can be processed efficiently, regardless of its original format or location.

3. **Build experiment dataset** 
  Recursively builds the `experiment_dataset`, which serves as the main input for SPC analysis. This step simply copies the dataset into the flow and aligns it with the correct connection, ensuring it is ready for further processing.

4. **Save dataset mode and parameters**  
   Updates project variables to indicate that the data source mode is `file_upload`. If parameters such as selected variables, date column, or subgroup size have been defined, they are also saved locally to be reused during analysis.

This scenario is designed to be fully automated — it can be safely re-run each time a new CSV file is uploaded, ensuring the experiment dataset and parameters remain consistent with the latest user input.

# Scenario: Extract Saved Study Information

[This scenario](scenario:EXTRACTSAVEDSTUDYINFORMATION) is used when the user chooses to integrate the Solution with a saved study from the **Parameters Analyzer** application.  
It extracts the configuration from the selected study (variables, specification limits, target parameter) and makes it available for SPC analysis in this Solution.

## Key Steps:

1. **Share and connect the dataset**  
   Shares the `saved_studies` dataset from the selected Parameters Analyzer instance and connects it to the current flow.  
   - If a previous instance was used, its dataset is unshared.  
   - The dataset is connected to the `compute_saved_study_extracted` recipe, enabling access to study content.

2. **Build extracted study information**  
   Builds the `saved_study_extracted` dataset, which contains the relevant configuration data (selected variables, target parameter, recommended zones, limits) for the chosen study.

3. **Add extracted information to variables**  
   Reads the extracted dataset and updates the project variables with:  
   - **Selected variables** from the study (including the target).  
   - **Specification limits (LSL/USL)** for each parameter, either from the study’s recommended zones or from the target’s selected range.  
   - These values are stored as local variables and will prefill the next steps of the application.  

---

This scenario ensures that SPC charts in this Solution are preconfigured consistently with the definitions set in Parameters Analyzer, eliminating manual re-entry of variables and limits.

# Scenario: Load Data and Create Charts

[This scenario ](scenario:LOADDATAANDCREATECHARTS)orchestrates the main SPC analysis.  
It connects the selected experiment dataset, prepares it for processing, and builds the outputs used to generate the SPC charts and capability metrics.  
The charts and dashboards are then created automatically when the flow is built.

## Key Steps:

1. **Share and connect experiment dataset**  
   If the data source is configured as a dataset (not a file upload), the experiment dataset from the selected project is shared with the current flow.  
   It is then connected to the `compute_experiment_dataset` recipe, ensuring the right input is used for analysis.  
   Previous datasets are unshared if they no longer match the current configuration.

2. **Change connection & engines**  
   Adjusts dataset connections and recipe execution engines to align with the project’s main connection.  
   This guarantees consistency and performance across the flow, even if datasets come from different sources.

3. **Configure sort order**  
   Ensures the experiment dataset is sorted correctly by the selected date column before analysis.  
   This step guarantees chronological consistency for the control charts.

4. **Extract information**  
   Builds the key datasets required for SPC analysis, including:  
   - `capability_metrics`  
   - `selected_study_data_enhanced`  
   - `process_capability_visualization`  

   These datasets provide the basis for the control charts, distribution plots, and capability metrics calculations.

5. **Create charts and populate dashboard**  
   The final steps of the scenario (now handled by Python recipes in the flow) generate the SPC charts and capability metrics, and update the dashboard.  
   For each selected variable, this includes:  
   - Control charts  
   - Distribution plots with specification limits  
   - Capability metrics (Cp, Cpk, Cpm, Cpkm, when applicable)  
   - A Cpk interpretation table  

---

This scenario is the core of the Solution: it transforms the input dataset into a complete set of SPC visualizations and metrics, accessible directly in the dashboard.
