The Input Dataset Preparation flow zone is where the additional features and the target variable are created. For a more in-depth understanding of this process, you may refer to the [Data Preparation](article:11) article, which provides additional conceptual information. 

![Screenshot 2023-04-21 at 15.20.23.png](5b0NachTDswV)

The first [prepare recipe](recipe:compute_dataset_has_product) flags each to indicate whether the customer possessed the product at each given time. The corresponding column in this model has been named has_product and is represented by binary values of 1 or 0. In addition, this recipe calculates the customer's age and the account's age at each observation date.

![Screenshot 2023-04-21 at 17.47.07.png](zhujRiOAVda3)

The following five window recipes are computing the following features: 
- [Window recipe 1](recipe: compute_date_prod_cust_holdings_prepared_windows): count of products held and total revenue per customer and observation date. 
- [Window recipe 2](recipe: compute_revenue_balance_features): total revenue sum, total revenue average, and total revenue standard deviation over the past six horizons. 
- [Window recipe 3](recipe: compute_date_prod_cust_holdings_prepared_windows2_2): min and max count of product held until the observation date. 
- [Window recipe 4](recipe: compute_additional_infos_lag_value):  lag value of 1 horizon of each additional information column added by the user as data input. 
- [Window recipe 5](recipe: compute_revenue_balance_features): subscription column. 

After applying the [window recipe 5](recipe: compute_revenue_balance_features), the output values that are possible for the "subscription" column include -1 (subscribed), 0 (did not subscribe), and 1 (unsubscribed). The subsequent [prepare recipe](recipe: compute_date_prod_cust_holdings_enriched_prep) aims to ensure that the subscription column is converted into the three possible values, which are 1 (subscribed), 0 (did not subscribe), and blank (undefined).

![Screenshot 2023-04-21 at 17.58.09.png](cnMvdDTFLQhM)

The [window recipe 5](recipe: compute_subscription_last_balance) computes for each row, the last value of the balance per product and customer ID. This new column is used in the first [pivot recipe](recipe: subscription_prepared_by_balance) to create one column per product and store the value of the last balance. The second [pivot recipe](recipe: compute_subscription_prep_other_products_holdings) flags for each product if the customer owns it or not, while the third [pivot recipe](recipe:compute_subscription_prep_other_products_holdings_1) stores the number of products owned within each product type. The two following prepare recipes are used to rename the column more explicitly.

To consolidate the newly computed information, the [join recipe](recipe:compute_train_subscription) utilizes a left join operation, merging the consolidated dataset with the three pivoted datasets. 

Finally, the [split recipe](recipe:split_date_prod_cust_holdings_prepared_subscription_by_product_joined) separates the [complete dataset](dataset:complete_dataset) into a [train](dataset:train_data) and a [to predict](dataset:to_predict_data) dataset. 




