
# Example:
# As the Python webapp backend is a Flask app, refer to the Flask
# documentation for more information about how to adapt this
# example to your needs.
# From JavaScript, you can access the defined endpoints using
# getWebAppBackendUrl('first_api_call')

import dataiku
import dataikuapi
import pandas as pd
from flask import request

project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)
variables = project.get_variables()
customer_dataset = dataiku.Dataset('data_distinct_customers').get_dataframe()

@app.route('/get_list')
def get_list():
    return json.dumps({"values": customer_dataset["customer_id"].values.tolist()})

@app.route('/get_variable')
def get_variable():
    recipe_filter = variables["standard"]["selected_customer"]
    return json.dumps({"selected_customer": recipe_filter})


@app.route('/set_variable', methods=["POST"])
def set_variable():
    selectedRecipe = request.get_json(force=True)
    variables["standard"]["selected_customer"] = selectedRecipe["customer_id"]
    project.set_variables(variables)
    
    return json.dumps({"selected_customer": selectedRecipe})
    


