## Definition

To calculate the Expected Impact, we need to consider the different **product mixes** involved. The product mix a customer is currently using is known as the **old product mix**. On the other hand, the product mix that a customer is expected to use if they consume the product we have calculated the probability for is the **new product mix**. 

While the expected gain calculation involves calculating the average revenue generated by the product over the past 12 months among the existing customer base, the second method groups this value by product mix. By doing so, we can gain a more granular understanding of the revenue generated by the product across different product mixes. 

The **Expected Impact** is calculated by subtracting the average revenue of a product within the old product mix from its value within the new product mix and multiplying this result by the **probability** that a customer will subscribe to the targeted product. 

## Formula

```Probability = Probability a customer will subscribe to this product [thereby shifting from old to new product mix] ```
```Total Avg Revenue Old = Average revenue over the past 12 months across all customers with the old product mix ```
```Total Avg Revenue New = Average revenue over the past 12 months across all customers with the new product mix ```
```Expected Impact = Probability * (Total Avg Revenue New - Total Avg Revenue Old)```

**Example**: 

Customer 1 currently owns products A and B, and we calculated the probability (0.70) of them using product C. Their old product mix consists of A and B, while their new product mix includes A, B, and C.

![Screenshot 2023-04-20 at 18.02.19.png](3MeWqqgE8jdi)
Expected impact of customer 1 to buy product C = (69 - 50) x 0.70 = 19 x 0.70 = 13.3$

Customer 2 only owns product A, and we calculated the probability (0.40) of them using product C. Their old product mix consists of A, while their new product mix includes A and C.

![Screenshot 2023-04-20 at 18.05.24.png](COdgcU5CNvMK)

Expected impact of customer 2 to buy product C = (39 - 15) x 0.40 = 24 x 0.40 = 9.6$

Total Expected Impact of product C = 13.3 + 9.6 = 22.9$ 





