The  **Project Setup**  allows users to customize parameters and use the solution with their own data through a visual interface. To make further adjustments to the project, the users still have the ability to go into the flow to  update parameters directly. 

To access the Project Setup interface, navigate to the project's homepage by clicking on the project name, then select "Project Setup."

![Screenshot 2024-11-06 at 12.16.01.png](YVQM0j2R33fb)

## Data update disclaimer 
Before beginning the Project Setup, users should read the disclaimer carefully. They have three options to replace the demo datasets with new data: uploading data from a computer, connecting to a database or copying settings from a Next Best Offer for Banking project.

![Screenshot 2023-07-12 at 14.38.52.png](FZrrckDT4J0V)

## Option 1 - Data upload

If the user chooses to  **upload data**  from their computer, the following datasets: [revenues_data](dataset:revenues_data),  [balances_data](dataset:balances_data), [customers_data](dataset:customers_data), [product_holdings_data](dataset:product_holdings_data), and [additional_information_data](dataset:additional_information_data), are uploaded by the user through the Project Setup interface.

![Screenshot 2023-04-24 at 11.34.11.png](ogUh69JZq1L3)

To refresh the project with new data, users can delete the existing datasets by clicking on the trash icon next to their name and then upload new files by dragging and dropping them or by clicking the "add a file" button.

After updating the datasets in the interface, users must press "check" to initiate the [Data upload - check schema](scenario:001DATAUPLOADCHECKSCHEMA) scenario, which will load the data, verify the schema, and build sync recipes to update the values and enforce the schema of the  [revenues](dataset:revenues),  [balances](dataset:balances), [customers](dataset:customers), [product_holdings](dataset:product_holdings), and  [additional_information](dataset:additional_information) datasets. 

## Option 2 - Data connection 

To update the project with new data, the user must update the connection settings section by connecting to a database.

![Screenshot 2023-04-24 at 11.36.19.png](KUIKFg6qjraS)

The project comes pre-configured with all datasets using the filesystem connection. The user can either keep this setup or change it to their preferred connection by modifying the connection settings section and clicking on "run" to reconfigure the flow connections. 

By clicking the links  [revenues](dataset:revenues),  [balances](dataset:balances), [customers](dataset:customers), [product_holdings](dataset:product_holdings), and  [additional_information](dataset:additional_information), the user will access the connection setting page and will be able to change the path to their datasets.

After updating the datasets in the interface, users must press "check" to initiate the [Data connection - check schema](scenario:002DATACONNECTIONCHECKSCHEMA) scenario, which will load the data, verify the schema, and remove the two sync recipes from the flow along with their respective input datasets.

## Option 3 - Copy connection and datasets

The Customer Segmentation solution completes the Next Best Offer for Banking solution within the marketing suite for banking. You can plug the same input data in both solutions. Additionally, you can use the segmentation output as input in the Next Best Offer for Banking solution.

![Screenshot 2023-07-12 at 14.41.36.png](1wTMgDX3ODvD)

## Subscription Probability Prediction

The first section to parameter is the Subscription Probability Prediction section. It allows the user to parameter the  **horizon**  on which you want the probability of subscription to be computed and select which  **product(s)**, if any, should be  **excluded**  from the prediction.

 _Ex: If you uploaded monthly data into the solution and wanted to compute the subscription probability over the next three months, the horizon would be 3._ 
 
![Screenshot 2023-04-24 at 13.41.08.png](XmcbYD74z4t0)

## Top Prospects for Cross-Sell

The Top Prospects for Cross-Sell section allows users to select some parameters about top prospects for cross-selling a selected product. It requires specifying the product to be analyzed and choosing between two methods to parameter the output:
- Top n method: Define the number of top customers to see as output. (ex: 100 customers)
- Hit ratio method: Define a minimal probability of subscription value. (0 < probability < 1)

The results of this analysis will be shown on the first page of the [Marketing Campaign Dashboard](dashboard:cSmw0hk).

![Screenshot 2023-04-24 at 15.58.27.png](MsbewTHRxHtA)

## Top Campaigns for Cross-Sell

The second marketing analysis will output top prospects for cross-selling each product in the data. It requires the user to fill in the Top Campaigns for Cross-Sell section to specify the number of top customers (ex: 100 customers) to see as output for each marketing campaign.

The results of this analysis will be shown on the second page of the [Marketing Campaign Dashboard](dashboard:cSmw0hk).

![Screenshot 2023-04-24 at 13.35.00.png](K5YrdAFt8QPO)


## Build the flow and generate results

Finally, by clicking on the run button, you can initiate the process of constructing the flow and generating the analysis.

![Screenshot 2024-11-09 at 16.45.58.png](Eif0x1KjI4II)

