# Walkthrough

To configure and execute the process, we will follow the steps in the [Project Setup](article:17).

The case study data is already in filesystem format, so we can skip the upload or connection steps and move straight to prediction and analysis parameters. If you're using your data, you'll need to upload or connect it before proceeding.

## Subscription probability prediction settings

The first section to parameter is the Subscription Probability Prediction section. It allows the user to parameter the  **horizon**  on which you want the probability of subscription to be computed and select which  **product(s)**, if any, should be  **excluded**  from the prediction.
 
![Screenshot 2023-04-24 at 13.41.08.png](XmcbYD74z4t0)

In this use case, we decided to calculate the probability of subscription over the next three months. Given that the data is measured on a monthly basis, this corresponds to a horizon of 3. Additionally, although all products were included in the feature engineering and exploratory analysis stages of the flow, we have excluded the Home Equity Loan and Current Account products from the subscription probability calculations.

## Top prospects for cross-sell settings

The Top Prospects for Cross-Sell section allows the user to select some parameters about top prospects for cross-selling a  **selected product** . It requires specifying the product to be analyzed and choosing between two methods to parameter the output:
- Top n method: Define the number of top customers to see as output. (ex: 100 customers)
- Hit ratio method: Define a minimal probability of subscription value. (0 < probability < 1)

The results of this analysis will be shown on the first page of the [Marketing Campaign Dashboard](dashboard:cSmw0hk).

![Screenshot 2023-04-24 at 15.59.33.png](k2d7PpHasEFD)

In this particular scenario, we have opted to analyze the most promising opportunities for cross-selling the Personal Loan product. Our selection process involved utilizing the Hit ratio method, whereby we established a minimum subscription probability threshold of 0.6 (60%).

## Top campaigns for cross-sell settings

The second marketing analysis will output top prospects for cross-selling each product present in the data. It requires the user to fill in the Top Campaigns for Cross-Sell section to specify the number of top customers to see as output for each marketing campaign.

The results of this analysis will be shown on the second page of the [Marketing Campaign Dashboard](dashboard:cSmw0hk).

![Screenshot 2023-04-24 at 13.35.00.png](K5YrdAFt8QPO)

In this use case, we have chosen to generate an output of the top 100 customers for each marketing campaign.

## Data Exploration

The dashboard that supports data analysis is the [Analytics and ML Model Dashboard](dashboard:pD1xvnF). 

The first slide, named  **Customer Base Analysis**, details descriptive statistics and analyses relating to the customers present in the input datasets.
![Screenshot 2025-02-20 at 18.51.51.png](oUlY6qkAVp5M)

At the top of the page, you can view KPIs related to the various customers, including the total number of customers, the average number of products held per customer, the average account age, the average customer age, and the period length of the input data. 

![Screenshot 2025-02-20 at 18.52.28.png](1GthPLAfdeD5)
The slide features multiple graphs, each accompanied by an explanation box on the right. For example, the second and third visuals illustrate the temporal variation in the percentage of customers belonging to different tiers and the same distribution in the most recent snapshot. 

![Screenshot 2023-04-24 at 17.15.29.png](yFtbL68CDJgI)

It is evident from the data that the most prevalent category of customers over the years has been the SILVER category. However, in recent years, there has been a surge in the number of customers belonging to the BRONZE group. Currently, the SILVER category makes up almost 70% of the customer base, while the GOLD and BRONZE categories account for approximately 15% each.

The second slide, **Product Holdings Analysis**, provides descriptive statistics and analysis on product holdings, product type mix, and product mix.

![Screenshot 2023-04-24 at 17.25.33.png](eVlIxJd6LFnp)

The metrics displayed at the top of the page provide valuable information such as the count of product types, the count of products, the distinct product type mix, the distinct product mix, and the most and least revenue-generating products.

![Screenshot 2023-04-24 at 17.51.59.png](YTECVzPuophT)

The slide features several graphs that are relevant to product holdings. For instance, the two tables located beside the bar chart display the top 5 product and product type mixes respectively. Meanwhile, the bar chart itself presents the total revenue generated per product and product type in the current year.

![Screenshot 2023-04-24 at 17.54.25.png](ee8zfj2HnlSg)

By examining the tables, we can observe that the most common product mix is Current Account, followed by Current Account x Saving Account. Additionally, the most popular product type mix is Deposit Account, followed by Secured lending x Unsecured lending. Meanwhile, on the bar chart, we can deduce that the product generating the highest revenue in the current year is Manage Securities, amounting to a total of 529.3k $. Conversely, the least revenue-generating product is Home Equity Loan.

## Machine learning model analysis 

The slide that supports machine learning model analysis is included in the [Analytics and ML Model Dashboard](dashboard:pD1xvnF). 

![Screenshot 2023-04-24 at 18.04.24.png](HaHlnUkB49jz)

This page presents detailed information about the model used to generate the subscription prediction, including a full report, a density chart, a confusion matrix, a variable importance plot, a what-if analysis, a subpopulation analysis, a partial dependence plot, and a fairness report. 

![Screenshot 2023-04-24 at 18.05.19.png](8vdzirgg8o8T)

For example, the variable importance plot reveals that the classification model places significant emphasis on several factors, namely whether the product in question is a Premium Credit Card or a Savings Account, as well as the age of both the customer and the account. However, it is worth noting that other characteristics also carry weight, such as whether the product is classified as Securities, whether the customer holds a Savings Account, the maximum number of products held, etc.

## Cross-sell analysis

Cross-sell analysis is a process of examining the impact of offering supplementary products to customers on the sales of already existing products. 

![Screenshot 2023-04-24 at 18.22.42.png](kareCqACYmpM)

This page shows metrics such as the direct, indirect, and total expected impact which are detailed in the following articles: 
- [Expected Impact](article:14)
- [Cross-sell Analysis](article:15) 

![Screenshot 2023-04-24 at 18.23.17.png](Fy7nwoj9VXb2)

The first chart displays the average cross-sell impact per product on the scored dataset. For instance, when examining Direct Securities, it is evident that the majority of the total expected impact is generated through direct impact. However, introducing Direct Securities still yields a positive indirect impact on other products that are already possessed.

## Top prospects for cross-sell analysis

The first page of the [Marketing Campaign Dashboard](dashboard:cSmw0hk) displays information regarding the list of top customers, which were selected based on the parameters configured within the Project Setup. This dashboard slide is designed to help a marketing team determine which clients are more likely to subscribe to a product.

![Screenshot 2023-04-24 at 18.31.58.png](o0QdTFgMs813)

Remember that in this used case, we have opted to analyze the most promising opportunities for cross-selling the Personal Loan product. Our selection process involved utilizing the Hit ratio method, whereby we established a minimum subscription probability threshold of 0.6 (60%). 

![Screenshot 2023-04-24 at 18.34.24.png](MOEQtD42HsRg)

The results on this page showcase that by selecting the customers having a probability to subscribe to the product Personal Loan higher than 60% totalize 2 086 customers. The total expected gain and impact of this selection are respectively 18 732$ and 19 089$. 

![Screenshot 2023-04-24 at 18.40.57.png](wEPfUyI0TQDc)

Furthermore, a dataset containing the chosen customers is provided at the bottom of the page, which can be utilized to target these selections with a marketing campaign promoting the Personal Loan product.

## Top campaign for cross-sell analysis

The second page of the [Marketing Campaign Dashboard](dashboard:cSmw0hk) presents a comparison of the gain and impact associated with each product analyzed, based on the parameters configured within the Project Setup. This dashboard slide has been created to assist a marketing team in identifying the products that are likely to provide the most value, as well as the top potential customers for each of these products.

![Screenshot 2023-04-24 at 18.46.08.png](ds9eKEpfF5ML)

In this use case, we have chosen to generate an output of the top 100 customers for each marketing campaign.
With these results, we can compare the top 100 customers for each product and determine which campaign has the potential to yield greater value. The first bar chart, for instance, indicates that Managed Securities is the product that is anticipated to generate the highest value, based on both the expected gain and expected impact. In fact, the top 100 customers for Managed Securities are projected to generate an expected gain of $2,497 and an expected impact of $2,205.

![Screenshot 2023-04-24 at 18.46.27.png](sveWNXKo7nXI)

Once again, a dataset comprising the chosen customers is available at the bottom of the page. However, in this case, since all products are included in the list, users can make use of the filters on the left-hand side to select only the products they are interested in.

## Customer focus analysis 

The [Customer Focus Dashboard](dashboard:7QptCyl) offers specific information about a  chosen customer. The purpose of this dashboard slide is to assist a counselor in gaining a deeper understanding of the likelihood that their customers will subscribe to a particular product. 

To find a particular customer and adjust the analysis accordingly, users can utilize the search engine located at the top of the page to select a Customer ID and update the visuals accordingly.

![Screenshot 2023-04-24 at 18.58.50.png](ud6uQkyOx3df)

The chosen customer on this page is Engracia Shepherdson with the ID 1000968. This customer is 37 years old and belongs to the tier SILVER. Its actual product type mix is Secured Lending x Unsecured Lending and its product mix is Car Loan x Mortgage x Personal Loan. 

Engracia has a 25.05% probability to subscribe to the product Managed Securities, a 19.42% probability to subscribe to the product Direct Securities, and an 8.08% probability to subscribe to the product Premium Credit Card. 

The expected gain and impact associated with the most revenue-generating product, Managed Securities, are respectively 8.3$ and 7.8$. 

# Conclusion 

The setup process is user-friendly, guiding users smoothly from prediction settings to cross-sell targeting. Key dashboards provide clear, visual insights into customer data and product trends, making analysis straightforward. The tailored parameters help focus on top prospects and campaigns, boosting marketing impact. Overall, the experience is efficient and valuable, supporting quick, data-driven decisions.

