# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
Sales_Lead_Feature = dataiku.Dataset("Sales_Lead_Feature")
df = Sales_Lead_Feature.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Rename sales product_revenue_weekly_leadX column to a standard format
# ==============================================================================
filter_col = [col for col in df if col.startswith('product_revenue_weekly_lead')]
df.rename(columns={filter_col[0]: 'product_revenue_weekly_lead'}, inplace=True)
df['product_quantity_weekly'] = df['product_quantity_weekly'].astype(int)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# Write recipe outputs
Sales_Lead_Feature_name = dataiku.Dataset("Sales_Lead_Feature_name")
Sales_Lead_Feature_name.write_with_schema(df)