# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
Sales_Marketing_aggr_by_account_id = dataiku.Dataset("Sales_Marketing_aggr_by_account_id")
df = Sales_Marketing_aggr_by_account_id.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
df.columns = df.columns.str.replace("_sum", "")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
numerical_col = df[df.columns.difference(['account_id', 'product_id','campaign_id'])].fillna(0).astype(int)
frames = [df[['account_id', 'product_id', 'campaign_id']], numerical_col]
result = pd.concat(frames, axis="columns")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE

# Write recipe outputs
Sales_marketing_feature_format = dataiku.Dataset("Sales_marketing_feature_format")
Sales_marketing_feature_format.write_with_schema(result)