In this article we list all the zones that lead to the Sales Deviation Analysis. 

![sales dev analysis zones.png](iMbpI0SgTtXd)

[Lead Feature Generation](flow_zone:R5aMtUg)

- [compute_Sales_marketing_filtered](recipe:compute_Sales_marketing_filtered) recipe filters the data to a user defined brand.  It is common that result of marketing campaigns do not take effect until after a number of weeks. In order to associate future sales with a given week's marketing campaign [compute_Sales_Lead_Feature](recipe:compute_Sales_Lead_Feature) window recipe creates a frame that groups sales by ```account_id``` and ```product_id``` for each week in the data. Then in the 'aggregations' tab, we can use the Lead operation to associate future sales with a given week (number X defined by the user) of marketing activities and generate the ```product_revenue_weekly_lead```. 
- python recipe standardizes the ```product_revenue_weekly_lead``` feature name for automation of the solution. 
- [compute_Sales_final_dataset](recipe:compute_Sales_final_dataset) prepare recipe generates the target column  ```sales_deviation```.  We first calculate the percentage difference of the weekly product revenue with the change in the next weeks computed from the window recipe. 
```sales_deviation_percent  = round((product_revenue_weekly_lead - product_revenue_weekly) / product_revenue_weekly * 100)```
If the ```sales_deviation_percent``` is greater or lower of a user defined threshoald variable ```sales_deviation_upper_filter``` and ```sales_deviation_lower_filter``` then the following equation labels the difference in sales as increase oor constant accordingly. 
```if((sales_deviation_percent) > ${sales_deviation_upper_filter},'Increase', if((sales_deviation_percent) < ${sales_deviation_lower_filter}, "Decrease", 'Constant'))```

[Sales Deviation Modeling](flow_zone:qJCfR9n)
Joins the providers characteristics to the aggregated dataset and trains a multiclassification model with target column ```sales_deviation``` and features the columns selected by the user on the DKU Application in variable format. 

Python recipe [compute_Sales_channel_chain_interactions](recipe:compute_Sales_channel_chain_interactions) analyses all the communication interactions of a target group (default: HCP specialty) for a specific channel (webcall). For example in the sample output dataset below, the recipe first filters the data for all the Neurology specialists and all the records that show at least one successful webcall. Then, we merge all the successful channel interactions in a chain and aggregate each communication chain group’s total revenue and interactions. The result column ```conversion_rate_per_interaction``` shows which combinations of channels seem to be more impactful given the total revenue and the number of interactions that took place. These results can be further used when optimizing the marketing suggestions for target groups. 

![Screenshot 2023-08-25 at 16.28.14.png](HwSrQhh4ZIoE)
