The **Project Setup** allows users to customize parameters and use the solution with their own data through a visual interface. To make further adjustments to the project, the users still have the ability to go into the flow to update parameters directly. To access the Project Setup interface, navigate to the **project's homepage** by clicking on the project name, then select "PROJECT SETUP".

![project setup.png](5vbU81sVRFNU)

You can connect your data regardless of the connection type and configure the whole flow according to your specific batch parameters seamlessly. 

### 1. Input your own data
There are two available options on the application and user should use one OR the other.
 
![data upload.png](AHk89PDob6AD)
**Upload data** in  **CSV**  format from your local machine: 
   - Select  **ADD A FILE**  and replace current files with  **Providers_input.csv, Product_input.csv, Transactions_input.csv, Omnichannel_input.csv**  files. 

   - Click on  **CHECK**  button to run a scenario that checks the format and schema of input data. If this step fails,  your data do not comply with the  required [Data Model](article:11). In this case, check the scenario logs to see which columns are missing or have the wrong type.

![data connection.png](SndUxJWLXcMK)
**Connect to a database** and update project data:
   -  **Select the connection**  that can connect to the [Input Datasets](article:11).
   ```in the example sample delivered with the project, the connection should be "filesystem_managed" as the dataset is stored as a local file```
    - click on the  **RECONFIGURE** button
Now that the connections are configured, you need to select the table/file that should be used as inputs within this connection : 
   - Click on  _ **Providers_input_dataset** _ . It will open the dataset configuration window, where you can select the table or file (depending on your connection type) that will be used as batch data. Once selected, click on  **SAVE**  in the top right corner, and come back to the application configuration page.
   - Repeat with **Product_input_dataset, Transactions_input_dataset, Omnichannel_input_dataset** 
  - Click on the  **CHECK**. If this step fails, it means that your data do not comply with the [required data model](article:11). In this case, check the scenario logs to see which columns are missing or have the wrong type.
  
### 2. Sales Deviation Marketing Analysis. 
 - **Run**  the first scenario to blend and preprocess all the data sources to create a dataset for descriptive visual analytics and the primary input dataset for machine learning modeling. 
 - **Filter**  parameters to prepare the data for predicting Sales Deviation (increase, decrease, or constant) for individual HCP accounts in the defined lead week window within the boundaries of change. Select the numerical and categorical features for the gradient descent machine learning multiclassification analytics session (see [Data Analytics](article:12)). 
 - **Run**  the second scenario to train a machine learning and genearate visualisations.
 - Once both of the scenarios are successfully completed, explore the [1. Sales Overview and Marketing Activity by Brand](dashboard:VEJI4w7).
 
![dku app sales deviation.png](B9NYM5gUe5Y9)

### 3. Brand Adoption 
Upon completing the Sales and Marketing Analysis, in this section we generate a binary ```brand_adoption``` feature on whether an HCP provider has “adopted” (purchased/prescribed) a product before or not and form a classification problem. 
 - **Select**  the multiple or a single brand and a time period **filter** the input training dataset. Moreover there is a flexibility on model numerical and categorical feature selection from the input omnichannel and provider characteristics datasets.  
 - **Run**  the scenario to train a machine learning model using those features.

![dku app brand adoption.png](arEwsbCXkTOY)

### 4. Score New Data
 - **Upload** a file with data records of individual HCP providers to score on whether they will adopt a brand or not given their characteristics and past marketing channel engagement. 
 - Select **Check** to verify that the input dataset contains all the features used above for training the model. In cae of missing features you will get an errror message. Check the scenario log files.  
 - We further extract feature importance and individual feature values for each account ID to explain which factors impact (positively or negatively) the probability of adoption. Select an Account ID to initiatie the visual displays in the [2. Brand Adoption by HCP](dashboard:4EblZMk). 

![uploadnewdata.png](NFPv8fpwBu2H)
  