# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu

# Read recipe inputs
Reports_faers_deduplicate = dataiku.Dataset("Reports_faers_deduplicate")
df = Reports_faers_deduplicate.get_dataframe()

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
column_names = ['age_group', 'adverse_event', 'reporter', 'reporter_country', 'drug']

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
column_values = pd.Series({col:df[col].unique() for col in column_names}).to_dict()
dataset_filters = dict([ (k,pd.Series(v)) for k,v in column_values.items() ])

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
final_dataset = pd.DataFrame(dataset_filters)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE

# Compute recipe outputs from inputs
# TODO: Replace this part by your actual code that computes the output, as a Pandas dataframe
# NB: DSS also supports other kinds of APIs for reading and writing data. Please see doc.


# Write recipe outputs
Report_faers_distinct_filters = dataiku.Dataset("Report_faers_distinct_filters")
Report_faers_distinct_filters.write_with_schema(final_dataset)