import dataiku
import dataikuapi
import pandas as pd
from flask import request

project_key = dataiku.get_custom_variables()["projectKey"]
client = dataiku.api_client()
project = client.get_project(project_key)
variables = project.get_variables()
drug_dataset = dataiku.Dataset('disproportionality_stats_threshold_distinct').get_dataframe()


@app.route('/get_list')
def get_list():
    return json.dumps({"values": drug_dataset["drug"].values.tolist()})


@app.route('/get_variable')
def get_variable():
    recipe_filter = variables["standard"]["drug_analysis"]
    return json.dumps({"drug_analysis": recipe_filter})

@app.route('/set_variable', methods=["POST"])
def set_variable():
    selectedRecipe = request.get_json(force=True)
    variables["standard"]["drug_analysis"] = selectedRecipe["drug"]
    project.set_variables(variables)
    return json.dumps({"drug_analysis": selectedRecipe})
    


