This project offers a foundation to leverage FAERS public database and further explore and detect potential signals in pharmacovigilance.

1. The current implementation of the solution runs on a local engine, hence the performance is relatively slow. The users are advised to change the connection to other databases that may provide in-database engines for more efficient computations of a large volume of data.

2. Filter formula in [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) uses ```arrayContains()```. Note that this function is not available on the SQL engine. In this case, the user is advised to convert this to a SQL expression. 

3. The number of drugs with adverse events that consist of the main computation tasks (through [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics) ) grows nonlinearly with the number of data records and may cause long running times. A handful number of prefilters is provided to direct the analysis towards targeted groups but also reduce the size of the data. An alternative / combined option is to work on a sample of data.  The scope of this solution has also been **limited to only looking for signals with drugs coded as the Primary Suspect in the report** and does not use Secondary or Concomitant Medications in the analysis.

5. When drug with adverse event pairs are generated in [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics) line 68 the array might be empty due to extensive filtering. A potential relevant warning:

```
WARNING: In case of ValueError: not enough values to unpack (expected 13, got 0).
```
Check that list_drug_event in  **NON**  empty. If this is the case, modify manufacturer and event frequency filters to allow more data to be processed.


