Prior to any analytics work the solution applies data standardization as explained in this [article](article:4). 

[Data Analytics / Statistics](flow_zone:QAy2Jyu) filters the data based on user-specified inputs and splits the dataset into subpopulation cohorts (Sex). The python script applies the DPA statistical approach (see [Data Analytics](article:5)) to detect potential warnings between various drugs and adverse events.
![zone data analytics stats.png](J3VG5WI9Vcpt)

 - [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) Filters the dataset to targeted groups and populations. The recipe uses global project variables as described in [Project Variables](article:22). Condition formula statements as:
``` if('${country_filter}' == [], asBool(1),  arrayContains('${country_filter}', reporter_country)) 
```

  If ```country_filter``` is empty then use all the countries in column ```reporter_country```, else filter for the countries contained in ```country_filter``` array set by the user on the Global Project Variables tab. 

 - [split_Reports_faers_deduplicate_filtered](recipe:split_Reports_faers_deduplicate_filtered) Splits the data into a cohort subpopulation (Sex) by mapping values "F", "M" into an output dataset. Other values are dropped. 
 
 - Python recipe [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics) 

1. Apply prefiltering on adverse event frequency and drugs by the manufacturer. All filters can be modified by global variables [Project Variables](article:22). 

2. Compute the measure of disproportionality statistics for each pair of drug with adverse event following [Data Analytics](article:5)

3. Outputs are individual dataset objects to further compare and detect potential signals. 