# Instance Requirements
This solution is only compatible on instances with  **Dataiku V13.3+**

## Code Environment
No code environment is needed to use this solution if running an instance with Python3 as the built-in environment. 

## Python Packages

All code scripts use Python Packages that are used and imported by default:
[Faers_data_ingestion](recipe:Faers_data_ingestion), [compute_FDA_products](recipe:compute_FDA_products)
```
import dataiku
import pandas as pd, numpy as np
from dataiku import pandasutils as pdu
import re
import io
```

[compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)
```
import itertools
import math
from fractions import Fraction as frac
from numpy import log as ln
```

[compute_Reports_faers_anonymization](recipe:compute_Reports_faers_anonymization)
```
import hashlib
```
Depending on the specifications of the user's instance, these packages may be tracked with future python updates. 

# Datasources Requirements
Some data sources are mandatory in order to use the solution, while others will be optional for further analysis.

## Input Files
To run this project the user is required to upload at least 5 datasets imported by the user as described in [Data Logs](article:3).

# Data Storage Requirements
The ***Pharmacovigilance*** Dataiku Application is designed to work with Filesystem -> filesystem - management connections, using the on-stream engine.
To benefit natively from all the Dataiku application automation, you will need to reconfigure one of the following connections :
- PostgreSQL
- Snowflake




