Project Variables may be defined and modified in the Variables project tab. The following variables are used to parametrize the project's flow. They may also be modified by the  [Dataiku Application](article:8) if the optional [Instantiate the flow](scenario:INSTANTIATETHEFLOW) scenario is triggered after the user filtered the selections. 

![variables.png](NBbimO30GZpv)

|       Variable   |Type | Values   | Comments | Flow Use  |
| ------------ |------------ |------------ |------------ |------------ |
| **anonymization_manufacturer_filter** |  Boolean | true / false | Dataiku application default value is  _false_  | [compute_Reports_faers_anonymization](recipe:compute_Reports_faers_anonymization)|
| **anonymization_drug_filter** |  Boolean | true / false | Dataiku application default value is  _false_  | [compute_Reports_faers_anonymization](recipe:compute_Reports_faers_anonymization)|
| **start_year_filter** |  Integer | Y | 2011 |[compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) |
|  **end_year_filter** | Integer |  Y | 2020 |  [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered)
|  **events_mode_filter** | String |"all", "most_frequent", "least_frequent", "select_individual"  | specify one of these options | [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)| 
| **events_frequency_filter** |  Float | 0.6 | Value range: 0.001 - 100 (upper limit if there is only one event) | [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)\
| **drugs_mode_filter** | String |"all", "select_individual_manufacturer", "select_individual_drug"  | specify one of these options | [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)| 
|  **manufacturer_filter** | Array | ```[Manufacturer_1, Manufacturer_2,..] ``` | accepts an array of multiple values | [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)| 
|  **drug_filter** | Array | ```[Drug_1, Drug_2,..] ``` | accepts an array of multiple values  | [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)| 
|  **adverse_event_filter** | Array | ```[Event_1, Event_2,..] ```  | accepts an array of multiple values  | [compute_Disproportionality_metrics](recipe:compute_Disproportionality_metrics)| 
|  **drug_exclude_filter** |  Array | ```[Drug_1, Drug_2,..] ```   | accepts an array of multiple values  |  [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) | 
|  **event_exclude_filter** | Array | ```[Event_1, Event_2,..] ```  | accepts an array of multiple values  |  [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) | 
|  **country_filter** | Array |  ```[Country_1, Country_2,..] ``` |  e.g. ```["US", "FR"] ```| [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) | 
|  **reporter_filter** | Array | ```[Reporter_1, Reporter,..] ```  | e.g. ``` ["Health Professional", "Lawyer"]``` | [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) | 
|  **age_filter** | Array | ```[Age_group_1, Age_group_2,..] ```  | e.g. ```[">=65", "12 : 21" ] ``` -  spaces before and after ":" | [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) | 
|  **country_filter** | String | "US" | accepts an array of multiple values | [compute_Reports_faers_deduplicate_filtered](recipe:compute_Reports_faers_deduplicate_filtered) | 
| **ROR_threshold** |  Float | A | e.g. default value: 1 | [compute_Disrpoportionality_stats_threshold](recipe:compute_Disrpoportionality_stats_threshold)|
| **PRR_threshold** |  Float | B | e.g. default value: 2 | [compute_Disrpoportionality_stats_threshold](recipe:compute_Disrpoportionality_stats_threshold)|
| **drug_analysis** |  String |``` drug_name``` | e.g. default value: "VEDOLIZUMAB" | [compute_Disrpoportionality_stats_threshold](recipe:compute_Disrpoportionality_stats_threshold)|


