# Pharmacovigilance Analytics Dashboard

[Pharmacovigilance analytics](dashboard:xHyTxW7) dashboard captures the general trends in the data and shows some visual insights, covering the flow until [Reports_faers_deduplicate](dataset:Reports_faers_deduplicate). It further uncovers the insights of potential warnings on the overall population from the safety reports and comparison graphs with the cohort analysis on the different genders.  Note that the underlined datasets used are:  [Reports_Faers_warning](dataset:Reports_Faers_warning) and [disproportionality_stats_threshold](dataset:disproportionality_stats_threshold).

# Descriptive Analytics

## Metrics
Shows the number of records after data preprocessing, and top values for drugs, adverse events, and manufacturers. Also, custom python metrics show the frequency of top individual events and seriousness categories. 
![overall.png](FbOWByhO7bSU)

## Safety Report Analytics
Pharmacovigilance analysis visualizes safety report trends by gender, age, seriousness, outcome, and reporter. The  Filters from  [Reports_faers_deduplicate_filtered](dataset:Reports_faers_deduplicate_filtered) tab enables selection of column values in the relevant dataset. Filters may also be deactivated completely. 

![tab2.png](jsbkNiRq5kfw)

# Statistical Analysis

## Disproportionality Analysis

This tab consists of an analysis of potential warnings between various drugs and adverse events. Graphs utilize the different disproportionality metrics as: Proportional Reporting Ratio, Reporting Odd Ratio, and the Bayes Mean measure and show the trends across the data. Filters on [disproportionality_stats_threshold](dataset:disproportionality_stats_threshold) may further modify this analysis on the most or least frequent drugs and events by percentage. 

![tab3.png](TSRu3ImFMcwR)

## DPA by Gender

Subpopulations are individually analyzed, and results are presented in this section in a comparative study. Top events and drugs measured for each gender along with graphs reveal potential warnings for each group. 

![tab4.png](211ywJLiNqWJ)

## Safety Report Signals

Based on the individual threshold set on the 95% lower confidence interval of Reporting Odd Ratio (default 1) and Proportional Reporting Ratio (default 2), this tab shows potential warnings between all the preselected drug x adverse event pairs. Individual safety report records are associated with the relevant pairs and further analyzed using other population and medications features. Metrics such as seriousness and age provide more levels of granularity for detecting populations that are likely at risk from different medications. 

![tab5.png](mKshahtgvHGb)















