<span id="version" style="color: grey; float: right">Version 1.2.0</span><br/>

**[Post-market drug safety surveillance](https://www.who.int/teams/regulation-prequalification/regulation-and-safety/pharmacovigilance#:~:text=Pharmacovigilance%20is%20the%20science%20and,they%20are%20authorized%20for%20use.)**  functions play a critical role in ensuring patient safety and securing successful drug launches and market presence. Controlled clinical trials are known to be both limited in time and patient diversity. Understanding the patient risk in the post-market application is necessary to validate the benefit-risk drug profiles. Moreover, compliance in safety reporting and surveillance are must-meet regulatory requirements. Failure to appropriately report, detect, or address adverse drug reactions can lead to patient harm, drug recall, and significant costs. Drug manufacturers, health care providers, and consumers report continuously (spontaneously) any adverse drug reactions, leading to a massive amount of safety data. Mining this data to detect unknown or novel risks is complex and time-consuming. Nonetheless, it is essential to ensure patient safety and the appropriate use of marketed therapeutics.

# Project Value

The Pharmacovigilance solution aims to provide a ready-to-use interface to accelerate the discovery of potential Adverse Drug Reaction (ADR) signals. This plug-and-play project enables users to upload quarterly data from spontaneous reporting systems and use statistical methods to generate disproportionality metrics on drugs and adverse events paired across various populations.

![overall.png](VJPHSjFpF2CV)

# Highlights

  - **Quickly ingest data files extracted**  from the FDA Adverse Event Reporting System ([FAERS](https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html)) database.
  
  - **Easily process the data**, detect duplicate reports, and filter on demographic, drug, reaction,  and report characteristics.

  - **Identify and visualize patterns**  in safety data with Dataiku’s descriptive analytics and charts.

![metrics.png](PL7nk25NTScS)
 
  - Calculate common **disproportionality metrics for statistical inference** and signal detection.

  - **Achieve immediate insights**  with a user-friendly Dataiku App to filter reports, generate signals for cohorts, and create drug/reaction analytics to  **ensure patient safety**. 
  
  - Increase  **regulatory compliance**  with early detection of **potential ADR signals **.
  
  - Discover **potential novel safety signals** previously undetected during clinical trials in diverse, longitudinal patient populations that lead to safety-related label changes (SRLC).
  
    ![stats.png](vjlo3b4hbqGx)
 
 


