The **[ FDA Adverse Event Reporting System (FAERS)](https://www.fda.gov/drugs/surveillance/questions-and-answers-fdas-adverse-event-reporting-system-faershttps://www.fda.gov/drugs/surveillance/questions-and-answers-fdas-adverse-event-reporting-system-faers) ** is a database that contains adverse event reports, medication error reports, and product quality complaints resulting in adverse events that were submitted to the FDA. The database is designed to support the FDA’s post-marketing safety surveillance program for drug and therapeutic biologic products.

According to the official FDA website, a simple search of FAERS data cannot be performed with these files by people who are not familiar with the creation of relational databases. Standard formats include:
 - [ASCII](https://networkencyclopedia.com/ascii-file/#:~:text=An%20ASCII%20File%20is%20a,ASCII%20file%20using%20Microsoft%20Notepad.) a file that contains unformatted ASCII text: only characters, numbers, punctuation, tabs, and carriage return characters.
 
 - [XML](https://networkencyclopedia.com/xml/) for Extensible Markup Language, a family of standards for the exchange of structured information.
 

 - In this project, users are required to upload the quarterly data of  **ASCII**  files in their initial raw format as provided in the FDA Adverse Event Reporting System (FAERS) Quarterly Data Extract Files following these steps:
   1. Go to[ FDA Adverse Event Reporting System (FAERS) Quarterly Data Extract Files](https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html) 
   2. Download ASCII zip files of different quarters
   3. Unzip the files locally
   4. Import the following datasets in the [Input Files](managed_folder:LbuXL8Es) folder
 
|    ASCII    |  Project Dataset            | Project Usage 
|------------|-------------------|-------------------|
| DEMOyyQq.TXT      | [Demographics_faers_input](dataset:Demographics_faers_input)       | Required |
| DRUGyyQq.TXT    |   [Medication_faers_input](dataset:Medication_faers_input)   | Required |
| REACyyQq.TXT      |  [Reaction_faers_input](dataset:Reaction_faers_input)    | Required |
| OUTCyyQq.TXT     |  [Outcome_faers_input](dataset:Outcome_faers_input)   | Required |
|  INDIyyQq.TXT     | [Indication_faers_input](dataset:Indication_faers_input) | Required |

yy - year, q - quarter

Analytical file descriptions and individual features are provided in details of each file and the column schema. For those used throughout this project, please see: 
[Demographics_faers_distinct](dataset:Demographics_faers_distinct) ,   [Medication_faers_distinct](dataset:Medication_faers_distinct),  [Reaction_faers_distinct](dataset:Reaction_faers_distinct) , [Outcome_faers_distinct](dataset:Outcome_faers_distinct) , [Indication_faers_distinct](dataset:Indication_faers_distinct).

Check that folder [Product Drug Names](managed_folder:Dh3OkheU) contains   ** _Product.txt_ **  file from [Orange Book](https://www.fda.gov/drugs/drug-approvals-and-databases/drugsfda-data-files). This file consists of a list of drugs and pharmaceuticals that the U.S. Food and Drug Administration (FDA) has approved as both safe and effective. This file can be downloaded via:
1. https://www.fda.gov/media/89850/download
2. Unzip the folder locally
3. Import dataset Product.txt in the dataiku folder [Product Drug Names](managed_folder:Dh3OkheU)

In case that link 1. doesn't work, follow:
1. Go to https://www.fda.gov/drugs/drug-approvals-and-databases/drugsfda-data-files
2. Under  _ **Download Files** _  select: ** Drugs[at]FDA Download File (ZIP - 3.57MB)** 
3. Same as above.
 



