The  **Pharmacovigilance**  business solution is oriented towards  **analytics teams** including pharmaceutical/drug manufacturers, regulatory systems, and patient care providers at pharmaceutical companies. The goal is to enable users to accelerate the discovery of potential signals that inform drug risk profiles in the market based on disproportionate reports from the  **FDA Adverse Event Reporting System**  (FAERS)s. Mining data from spontaneous reporting systems to detect novel risks is a complex and time-consuming task among drug manufacturers. To promote patient safety and the appropriate use of marketed therapeutics, this solution provides a plug-and-play starting project.

 **Statement of Declaration**: The case study below runs on a sample of public data, and any results from statistical analysis are not tangible conclusions linked to any manufacturer or drug. Users are encouraged to plug full datasets of entire quarters from FAERS and drive their own analysis along the same or different directions. 

# Case Study: Enhancing Post-Market Drug Safety with the Pharmacovigilance Dataiku Solution**

**Company Background**  
 **SafePharma Inc.** , a global pharmaceutical company, markets a diverse portfolio of drugs across multiple therapeutic areas. One of its key drugs, Ozempic™, a medication for managing type 2 diabetes, has garnered significant market attention. However, with its increasing off-label usage for weight loss and other uses, SafePharma is under pressure to monitor and manage potential  **Adverse Drug Reactions**  (ADRs). The company aims to enhance patient safety, comply with regulatory requirements, and maintain trust in its products.  

**Challenges**  
SafePharma faces several challenges in post-market safety monitoring:  
1. **Data Overload:** Massive volumes of safety data from the FDA Adverse Event Reporting System (FAERS) make manual signal detection time-consuming and error-prone.  The quality of self-reporting data before preprocessing imposes challenges with several duplications from multiple parties.
2. **Compliance Pressure:** Regulatory agencies demand timely identification and reporting of ADR signals.  
3. **Insights Gap:** Understanding ADR patterns across demographic cohorts and specific drugs is critical but complex.  
4. **Limited Analysis Tools:** The lack of advanced analytics hinders effective exploration of disproportionality metrics and signals.  

To address these challenges, SafePharma deployed the **Pharmacovigilance Dataiku Solution** to transform its approach to drug safety monitoring.  

### **1. Data Ingestion**  
SafePharma’s pharmacovigilance team uploads FAERS quarterly data for 2024. These datasets include information on demographics, drugs, reactions, outcomes, indications, and product details.  

### **2. Data Filtering and Preprocessing**  
The analytics team, filter and preprocesses the data to focus on relevant demographics, drugs, and adverse events.  
- **Date Range:** 2022–2024  
- **Drugs:** Focus on key medications like Ozempic™, Xolair™, and Actemra™.  
- **Excluded Events:** Removed COVID-19-related events to avoid noise.  
- **Age Group:** Focused on reports from patients aged 35–65.  
- **Geography:** Limited to the US market.  

The preprocessing step anonymizes manufacturers to prevent bias. After filtering, the processed dataset highlights more than 90,000 relevant records.  

### **3. Statistical Analysis**  
Using disproportionality metrics, the team calculates:  
- **ROR:** Indicates the likelihood of an ADR being associated with a specific drug compared to other drugs.  
- **PRR:** Measures the relative frequency of a drug-reaction pair.  
- **EBGM:** A Bayesian metric for signal detection.  

Confidence intervals (95% CI) are used to confirm signal strength with ROR and PRR thresholds to flag significant signals.

### **4. Dashboard Insights**  
#### **Safety Report Analytics**  
- **Trend Analysis:**  
  - A spike in ADR reports is observed in early 2024, primarily from the female population.  
  - Serious events are predominantly reported among patients aged 50–60.  
 ![d2.png](OFHaLexhvmEF)
 
#### **Disproportionality Analysis**  
- **Potential Signals:**  
  - ROR analysis flags Ozempic™ with potential signals for nausea and vomiting.  
  - Both Ozempic™and Xolair™ show significant warnings for off-label use.  
![table.png](uaYX58m9KUao)

#### **ADR by Gender**   
- **Cohort Analysis:**  
- Gender-specific ROR analysis reveals higher odds of nausea for females taking Ozempic™, while male patients show a lower likelihood of reporting the same ADR.  
- Comparative analysis highlights unique signals that are invisible in aggregated data.  
- Gender cohort reporting ratios for drugs like Ozempic™ and Xolair™.  
- Differences in ADR signals between male and female populations.  

### **5. Decision-Making and Export**  
SafePharma’s team uses the insights to:  
- Focus safety monitoring efforts on flagged signals (e.g., nausea with Ozempic™).  
- Prioritize outreach to high-risk cohorts (e.g., females aged 50–60).  
- Export filtered datasets for further investigation and case management.  

### **6. Business Impact**  
By implementing the **Pharmacovigilance Dataiku Solution**, SafePharma achieved:  
1. **Enhanced Signal Detection:** Rapid identification of ADRs using disproportionality metrics and visualizations.  
2. **Improved Compliance:** Early warning signals and timely reporting to regulatory bodies.  
3. **Cohort-Specific Insights:** Tailored monitoring for high-risk demographics.  
4. **Operational Efficiency:** Automated workflows reduced manual effort and improved reliability.  

### **7. Conclusion**  

The Pharmacovigilance Dataiku Solution empowered SafePharma to navigate the complexities of post-market drug safety. By leveraging advanced analytics and automation, the company ensured patient safety, met regulatory requirements, and sustained market confidence in its products. This scalable solution positions SafePharma as a leader in data-driven pharmacovigilance practices.  