A common approach for screening spontaneously reported data and detecting potential signals for further investigation due to the "case-only" nature of the data is   **Disproportionality Analysis (DPA)**. In the absence of "control" data (patients who did not have an adverse drug reaction), we can gain insights on potential safety signals by finding pairs of drug and adverse reactions that are reported disporportionately often in comparison to other drug and other reaction events. The Contingency Table shows statistical associations between  **medicinal products and adverse events**  that are further used for the computation of the statistical metrics we use in this work. 

 **Contingency Table:** 
|          |Drug of interest (x) | All Other Drugs | Total|
| ------------ |------------ |------------ |------------ |
| **Adverse Event or interest (y)** |  a| b| a + b|
|  **All other Adverse Events** | c |d |c + d|
|  **Total** | a + c |b + d |a + b + c + d|

 - a = The number of reports of the drug of interest (X) with the adverse event of interest (Y)
 - b = The number of reports of all other drugs with the adverse event of interest (Y)
 - c = The number of reports of the drug of interest (X) with all other adverse events
 - d = The number of reports of all other drugs with all other adverse events

Several statistical **"measures of disproportionality"** help make decisions about clinical interventions or draw conclusions about the associations of various substances or events in health-related situations. It is important to note that this measure of association **does not and should not be used to imply causation**.  In this project we generate the following metrics: 
**Statistical Metrics**
| Name         | Initial       | Explanation
| ------------ |------------ | ------------ | 
| Reporting Odds Ratio      | ROR    |   The odds of an adverse event occurring with a specific medicinal product compared to the odds of the same event occurring with all other medicinal products in the same database.  
| Proportional Reporting Ratio      | PRR    | Measures how common an adverse event occurs with a specific medicinal product compared to the same event occurring with all other medicinal products in the same database.
|Empirical Bayes Geometric Mean | EBGM | Measure of association that can be thought of as a relative reporting ratio based on Multi-Item Gamma-Poisson Shrinker (MGPS). 

```math
{\displaystyle  ROR =  \dfrac{ad}{bc}}
``` 
```math
{\displaystyle  PRR =  \dfrac{a/(a + c)}{b/(b + d)}}
``` 
```math
{\displaystyle  CI_{(PRR)}  = e^{(ln(PRR) - \sqrt(\dfrac{1}{a} + \dfrac{1}{b} + \dfrac{1}{c} + \dfrac{1}{d})) } }
``` 
```math
{\displaystyle  CI_{(ROR)}  = e^{(ln(ROR) - \sqrt(\dfrac{1}{a} + \dfrac{1}{b} + \dfrac{1}{c} + \dfrac{1}{d})) } }
``` 
```math
{\displaystyle   EBGM = (a*(a + b + c + d)) / ((a + c)*(a + b))}
``` 

 **Example:**  
 - PRR of 2 for a drug / adverse event combination indicates that the proportion of reports for drug event combination is twice the proportion of the event in the overall database.
 - ROR of 3 for a drug / adverse event combination indicates that the odds of reports of this event with the specific drug are three times higher than the odds of the reports of this event among all other drugs in the database.  
 
These measures will return a higher score when a particular drug is associated with a specific adverse event more than expected (i.e., more than other drugs). Hence both metrics offer an indication of the strength of the signal but not a quantification. 

For the uncertainty estimation, the 95% confidence intervals (CI) of ROR and PRR give evidence of precision. A signal is considered when the confidence interval is greater than a threshold (often 1, indicating significant increased association/reporting). The reference risk is thought to reflect the baseline risk of the reporting of an event in the subject of taking a drug.


For more information and research validation please see [Appendix](article:13).

-  **Reporting Odds Ratio (ROR)** :
Focuses on odds. It calculates how much more likely (or unlikely) an adverse event is reported for a specific drug compared to all other drugs. It evaluates the odds of reporting the event with a drug versus without it.

-  **Proportional Reporting Ratio (PRR)** :
Focuses on proportions. It measures how common a specific adverse event is for a drug compared to the proportion of the same event across all other drugs. It evaluates the frequency of reports relative to the total number of reports.
 





