The following scenarios automate parts of the computation of the flow and are either triggered through the [Project Flow](article:7) or the [Dataiku Application](article:8). 

![Screenshot 2022-09-02 at 20.33.54.png](aODvXlThmU46)

 1. [Flow Build](scenario:FLOWREBUILD): Runs [Input Files](flow_zone:default) to read and parse the input files. Checks that folders contain a minimum number of the required files. Also runs all the data preprocessing steps [Data Preparation (Demographics)](flow_zone:hvxs12U), [Data Preparation (Drug - Indication)](flow_zone:II0EYcK), [Data Standardization (Drug)](flow_zone:MjoJimd), [Report Deduplication](flow_zone:AhX9Wwy). Checks that the joined dataset is nonempty and generates the statistical cards and charts published in [Dashboards](article:9) - [Pharmacovigilance descriptive analytics](dashboard:xHyTxW7). 

 2. [Filter subpopulations](scenario:GENERATESUBPOPULATIONFILTERS) Filters the data on the variables specified by users in Global Variables. Runs the metrics and checks that the dataset is nonempty. Further splits the final dataset into a subpopulation category (Gender) to be used for statistical analysis. 

 3. [Generate statistical metrics](scenario:GENERATESTATISTICALMETRICS) Generates the statistics for drug x adverse event pairs for the entire filtered dataset and the two subpopulations as described in [Data Analytics](article:5). Computes metrics that indicate the signal of drugs with adverse events and updates all the published insights graphs in [Pharmacovigilance analytics](dashboard:xHyTxW7)

 4. [Instantiate the flow](scenario:INSTANTIATETHEFLOW) Optionally runs at the end of the [Dataiku Application](article:8). The local variables set by the user will be copied into the global variables directory using [Load application variables](scenario:LOADAPPLICATIONVARIABLES), allowing the project to execute. Scenarios ```[1-3] ``` are automatically triggered to rebuild the entire flow.

 5. [Refresh Analytics Dashboard](scenario:REFRESHANALYTICSDASHBOARD) updates all the chards in  [Pharmacovigilance descriptive analytics](dashboard:xHyTxW7) dashboard. 
 
 6. [Reconfigure flow connections](scenario:RECONFIGUREFLOWCONNECTIONS) enables users to remap connections of the entire flow to Snowflake or SQL database (set by default). This scenario can be triggered manually on the project flow or automatically through the Dataiku Application. 
 
Note that for 5 - 6, statistics and metrics are automatically updated every time the underlined datasets change. Charts in the dashboard are not changing in the same way and require either manual update or automatic for collectively updating them.





