import datetime
import json
import os
from flask import Blueprint, make_response
from flask import Response

from pathlib import Path
import dataiku

from commons.python.fetch.static_resources import fetch_route
app.register_blueprint(fetch_route)


get_metrics_bp = Blueprint("get_metrics_bp", __name__)

def get_blue_prints():
    return [get_metrics_bp]




class Graph:
    def __init__(self, graph_name, graph_type, dom_id):
        self.name = graph_name
        self.type = graph_type
        self.dom_id = dom_id


class GaugeGraph(Graph):
    def __init__(self, graph_name, dom_id, value, y_min, y_max, serie_name, unit, value_name):
        Graph.__init__(self, graph_name, "gauge", dom_id)
        self.y_min = y_min
        self.y_max = y_max
        self.value = value
        self.serie_name = serie_name
        self.unit = unit
        self.valueName = value_name


class BarGraph(Graph):
    def __init__(self, graph_name, dom_id, x_values, y_values):
        Graph.__init__(self, graph_name, "bar", dom_id)
        self.x_values = x_values
        self.y_values = y_values


class ScatterGraph(Graph):
    def __init__(self, graph_name, dom_id, values, average):
        Graph.__init__(self, graph_name, "scatter", dom_id)
        self.values = values
        self.average = average


class LineGraph(Graph):
    def __init__(self, graph_name, dom_id, x_values, y_values, average):
        Graph.__init__(self, graph_name, "line", dom_id)
        self.x_values = x_values
        self.y_values = y_values
        self.average = average


class StackBar:
    def __init__(self, name, values):
        self.name = name
        self.values = values


class StackedGraph(Graph):
    def __init__(self, graph_name, dom_id, x_values, y_values_set):
        Graph.__init__(self, graph_name, "stacked", dom_id)
        self.x_values = x_values
        self.y_values_set = y_values_set


class RadialPolarGraph(Graph):
    def __init__(self, graph_name, dom_id, radius_values, polar_values):
        Graph.__init__(self, graph_name, "radial_polar", dom_id)
        self.radius_values = radius_values
        self.polar_values = polar_values


class PQCMetrics:
    def __init__(self, status, graphs):
        self.status = status
        self.graphs = graphs




# Extract metrics from datasets
# Daily production rate:
daily_production_rate = dataiku.Dataset('process-data-joined-new_prepared_by_DateTimeDay')
daily_production_rate_df = daily_production_rate.get_dataframe()
last_day = daily_production_rate_df.days_since_max_timestamp_first.min()
daily_production_rate_df_7days = daily_production_rate_df[daily_production_rate_df.days_since_max_timestamp_first <= (last_day + 7)]
daily_production_rate_df_7days['GoodInjections'] = daily_production_rate_df_7days["defect_count"] - \
                                                   daily_production_rate_df_7days["defect_sum"]

daily_prod_x = daily_production_rate_df_7days.timestamp_day.tolist()
daily_prod_y_good_injections = daily_production_rate_df_7days.GoodInjections.tolist()
daily_prod_y_defect_sum = daily_production_rate_df_7days.defect_sum.tolist()




# 24h total production Gauge
LastProduction = dataiku.Dataset('process-data-joined-new_prepared_filtered_by_days_since_now_prepared')
LastProduction_df = LastProduction.get_dataframe()
total_production = round(float(LastProduction_df[LastProduction_df[dataiku.get_custom_variables()["equipment_id_col"]] != ""]["defect_count"].sum()), 2)

# Defect Rate Gauge
defect_rate = round(float(LastProduction_df[LastProduction_df[dataiku.get_custom_variables()["equipment_id_col"]] != ""]["defect_rate"].mean()), 2)


influencing_factors = dataiku.Dataset('24h_explanations')
influencing_factors_df = influencing_factors.get_dataframe()
influencing_factors_df = influencing_factors_df.nlargest(3, columns='value')

influencing_factors_df['value_pct'] = 100*influencing_factors_df['value']/influencing_factors_df.sum()[1]



#Most influencing factors:

factors_x = influencing_factors_df['value_pct'].round(1).tolist()
#factors_x = ['{:.0f}%'.format(elm) for elm in influencing_factors_df["value_pct"]]
factors_y = influencing_factors_df['factor'].tolist()
# Line data:
process_data_days_since_now = dataiku.Dataset('new_prepared_24h_filtered_factors')
process_data_days_since_now_df = process_data_days_since_now.get_dataframe()
process_data_days_since_now_df = process_data_days_since_now_df.sort_values(by=['timestamp_hours'])
process_data_days_since_now_df = process_data_days_since_now_df.dropna()
# Average Data:
process_data_days_since_now_avg = dataiku.Dataset('new_prepared_24h_filtered_factors_gpby')
process_data_days_since_now_avg_df = process_data_days_since_now_avg.get_dataframe()

sparkline_x = process_data_days_since_now_df.timestamp_hours.tolist()
factor_1_sparkline_y = round(process_data_days_since_now_df[dataiku.get_custom_variables()["factor_1"]], 2).tolist()
factor_2_sparkline_y = round(process_data_days_since_now_df[dataiku.get_custom_variables()["factor_2"]], 2).tolist()
factor_3_sparkline_y = round(process_data_days_since_now_df[dataiku.get_custom_variables()["factor_2"]], 2).tolist()



if (process_data_days_since_now_avg_df.empty):
    factor_1_sparkline_average = 0.0
    factor_2_sparkline_average  = 0.0
    factor_3_sparkline_average  = 0.0
else:
    factor_1_sparkline_average = round(process_data_days_since_now_avg_df[dataiku.get_custom_variables()["factor_1"] + "_avg"], 1)[0]
    factor_2_sparkline_average = round(process_data_days_since_now_avg_df[dataiku.get_custom_variables()["factor_2"] + "_avg"], 1)[0]
    factor_3_sparkline_average = round(process_data_days_since_now_avg_df[dataiku.get_custom_variables()["factor_3"] + "_avg"], 1)[0]



# defect rate
defect_rate_per_machines = dataiku.Dataset('defect_rate_per_machines')
defect_rate_per_machines_df = defect_rate_per_machines.get_dataframe()
defect_rate_radius = defect_rate_per_machines_df.total_production.tolist()
defect_rate_theta = defect_rate_per_machines_df[dataiku.get_custom_variables()["equipment_id_col"]].tolist()

metrics = PQCMetrics('ok', [GaugeGraph('24h total production',
                                       '24h_total_production',
                                       total_production,
                                       0,
                                       2000, 'number of injections',
                                       '', 'Injections'),
                            GaugeGraph('defect rate',
                                       'defect_rate',
                                       defect_rate,
                                       0,
                                       100,
                                       'Defect Rate', '%', 'Defect Percentage'),
                            BarGraph('Most influencing factors', 'most_influencing_factors',
                                     factors_x,
                                     factors_y),
                            LineGraph(dataiku.get_custom_variables()["factor_1"], 'factor_1_24h_avg',
                                      sparkline_x, factor_1_sparkline_y, factor_1_sparkline_average),
                            LineGraph(dataiku.get_custom_variables()["factor_2"], 'factor_2_24h_avg',
                                      sparkline_x, factor_2_sparkline_y, factor_2_sparkline_average),
                            LineGraph(dataiku.get_custom_variables()["factor_3"], 'factor_3_24h_avg',
                                      sparkline_x, factor_3_sparkline_y, factor_3_sparkline_average),
                            StackedGraph('Daily production rate (last 7 days)', 'daily_production_rate_last_7_days',
                                         StackBar('Date', daily_prod_x),
                                         [StackBar('Good Products', daily_prod_y_good_injections),
                                          StackBar('Defects', daily_prod_y_defect_sum)]),
                            RadialPolarGraph('Defect rate per machine', 'defect_rate_per_machine', defect_rate_radius,
                                             defect_rate_theta)

                            ])


@app.route('/getMetrics')
def get_metrics():
    return json.dumps(metrics.__dict__, default=lambda o: o.__dict__, indent=4)
    #return json.dumps(metrics.__dict__)

