 ## Overview
In this flow zone, the goal is to detect the drifts in the injection time, as seen in the [Defects prediction dashboard](dashboard:hbZqqVP), and notify another team.
![flow_zone_drift_alerts.png](JQgO3Ab0UNzU)

## Drift detection
As a starting point, we use a window recipe to compute the average and standard deviation of the  _injection time_  per  _recipe_. 
To get better results, labeled data on drifted campaigns could have been used, but the results are good enough and we wanted to keep close to the manufacturing context in which it's generally costly to label production campaigns. However, it could be a good idea if you need to enhance the alerting time!
The next step is to use a prepare recipe to compute the _ Upper Control Limit_, defined at 3 sigma away from the average line (inspired by six sigma's control charts). Finally, we define the  _Alert_  variable at 1 for each  _injectionTime_  over this _ Upper Control Limit_.

Below, an example of the alerts raised for some campaigns of the machine W06 (per-hour agregation):
<span style="color:red">Upper Control Limit is in red</span>,  <span style="color:green">InjectionTime in green</span> and <span style="color:orange">the Sum of alerts in orange</span>:
![ucl_alerts_chart.png](ohleo0hK3jJ9)


As you can notice, it's raising many alerts! To avoid raising too many notifications, we are again using a window recipe to count the number of alerts raised. When it goes over a defined threshold (currently set to 800, the campaign is considered as drifted. This technique is used to have a simple parameter to tune and get better results. 

![ucl_alerts_threshold_chart.png](33lFSE082kzO)

If you have difficulty detecting drifts, it could also be done with a machine learning model, but it would require labeled data to be accurate.

Lastly, you might have noticed that all the alerts are recomputed each time. We decided to have only one branch in this zone to have it easier to explain, although it's not optimal for computing time. Then, you may consider using this zone for backtesting and copying the alerting process to the Last 24-h data zone. Lucky you, Dataiku allows you to copy an entire flow zone pretty easily!

![flow_zone_copy.gif](QIC3CzhTEQyE)


## Alerting
Thanks to this previously defined algorithm, we know how to detect drifts in InjectionTime. The next step is to raise alerts in order to notify the maintenance team. This part is covered in the [setting up alerts article](article:8).


