# Introduction
As seen in the [Project's goal and value](article:2), this solution aims to reduce the detection time of manufacturing defects thanks to a visually trained model. If we have a look at the data, we can notice several patterns. Especially a well-known problem in the factory is the injection time drift caused by a machine that needs a recalibration.
<br>
# Usual campaign behavior
For this case study, we'll focus on the machine (Press) ```W13``` as it contains all the patterns we want to show.  A usual production campaign should look like the ```W13-5400-7047```, with no injection time drift, even though there's a clear trend when the injection time is over a certain threshold and few outliers :
![usual_campaign.png](sPdYp1G7aFkF)
[DateTime vs InjectionTime on Process_data_joined_quality](insight:3Jcz7Hi)

It would be difficult to determine all the injection time threshold for each machine-recipe couple, hence the interest of the model. Moreover, it is probably also related to other parameters external to the dataset that create the outliers we observe in the charts.

If we check the 2 other variables (temperature and pressure), we don't observe a similar threshold pattern:
![usual_campaign_1.png](QMTuMfCCkGsN)
[DateTime vs Temperature on Process_data_joined_quality](insight:8fZYUzf)
![usual_campaign_2.png](DFT9kVEkvTyL)
[DateTime vs Pressure on Process_data_joined_quality](insight:Zwk1Ayp)

There are still some outliers, but it doesn't seem correlated with defects.
<br>
# Unusual campaign behavior: drift
A known problem from the factory is the injection time drift caused by the machine that needs a recalibration, seen in the campaign ```W13-5244-8282``` for instance:
![unusual_campaign.png](nVH5n6LJdxYj)
[DateTime vs InjectionTime on Process_data_joined_quality](insight:XAY8cq8)

Without the intervention of the maintenance team, the drift can occur on several campaigns in a row, as seen in the ```W13-5244-8282``` and ```W13-5310-7571```:
![drifted_campaigns.png](KzcdpZEb7bhB)
[DateTime vs InjectionTime on Process_data_joined_quality](insight:bTB9yOF)

This is a  typical issue encountered in the manufacturing industry where the workforce can't individually monitor all the machines and, as explained in the [Project's goal and value](article:2), the delay between the beginning of the machine’s malfunction and its detection is long due to the in-line operations without intermediate quality control.
<br>
# Drift detection and alerting system
The goal of the third tab of the dashboard is to detect the drifts without a machine learning model and alert other teams when a drift is detected. All the drift detection mechanism is explained in the [Drift detection & alerting.](article:13)
<br>
# Improve manufacturing process understanding
Once a model has good results, the explainability features of Dataiku are helpful for understanding its outcomes. 
In this solution, we trained a random forest without a time series approach where some features are extracted, it's only valid for unitary scoring. You can find more information on the model in the [defect prediction article.](article:12)
The [defect prediction dashboard](dashboard:hbZqqVP) shows how to enhance its understanding of the manufacturing process.
It starts with a model evaluation that is very important to be sure the results are relevant. 
There's also the feature importance where we see the very strong impact of the Injection time:
![variable_importance.png](cVuZB0UAFIrd)
Finally, still in the first tab, the partial dependence plot shows the depence of the predicted response on a single feature. It's helpful to understand the links between the quality results and a given processs variable. 
![pdp.png](8jOV974upNMb)
Another way to explore the model outcomes is the[ interactive scoring](https://doc.dataiku.com/dss/latest/machine-learning/supervised/interactive-scoring.html) available in the second tab of the dashboard. It's helpful to tweak the input features of the model and see in real-time its prediction and the associated explanations.
![interactive_scoring.png](prNf7NYC1P3F)
<br>
# Live insights to the shop floor
A good way to involve and communicate information to production teams is to display visual management directly on the shop floor. To this end, we created the Production Quality Dashboard that displays information from production data but also results from the machine learning model.  
You can find more information on the dashboard in the [Production Quality Dashboard article.](article:16)
![webapp.png](HViicbmr3RDd)
<br>
# Conclusion
Without coding, we have seen several approaches to reduce the detection time of manufacturing defects thanks to a machine learning model and use the explainability features of Dataiku to understand better the manufacturing process. A drift detection system helps to involve other teams such as maintenance with live alerting, and finally, we can display live insights to the shop floor. 