## はじめに
[プロジェクトの目的とバリュー](article:2)にあるように、このソリューションは、視覚的に学習されたモデルによって、製造上の欠陥の検出時間を短縮することを目的としています。データを見てみると、いくつかのパターンに気づくことができます。特に、工場でよく知られている問題は、再校正が必要な機械によって引き起こされる射出時間のドリフトです。
<br>
## 通常の流れ
このケーススタディでは、見せたいパターンがすべて含まれているマシン（プレス）```W13```に焦点を当てます。通常の生産では、```W13-5400-7047```のようになるはずです。射出時間がある閾値を超えると明確なトレンドがあり、異常値はほとんどないにもかかわらず、射出時間のドリフトはありません :
![usual_campaign.png](sPdYp1G7aFkF)
[DateTime vs InjectionTime on Process_data_joined_quality](insight:3Jcz7Hi)

各マシンとレシピのカップルの射出時間の閾値をすべて決定することは困難であり、それゆえにこのモデルの面白さがあります。さらに、グラフで観察される異常値を作り出すのは、おそらくデータセットの外部の他のパラメータとも関係があります。

他の2つの変数（温度と圧力）を確認すると、同様の閾値パターンが観測されないことが分かります。
![usual_campaign_1.png](QMTuMfCCkGsN)
[DateTime vs Temperature on Process_data_joined_quality](insight:8fZYUzf)
![usual_campaign_2.png](DFT9kVEkvTyL)
[DateTime vs Pressure on Process_data_joined_quality](insight:Zwk1Ayp)

まだ外れ値はありますが、不具合との相関はなさそうです。
<br>
## 異常な運動：ドリフト
このデータセットでは、工場からの既知の問題は、例えば ``W13-5244-82`` で見られるように、再キャリブレーションを必要とする機械によって引き起こされる射出時間のドリフトです。

![unusual_campaign.png](nVH5n6LJdxYj)
[DateTime vs InjectionTime on Process_data_joined_quality](insight:XAY8cq8)

メンテナンスチームが介入しないと、``W13-5244-82``と``W13-5310-7571``に見られるように、連続してドリフトが発生する可能性があるのです。
![drifted_campaigns.png](KzcdpZEb7bhB)
[DateTime vs InjectionTime on Process_data_joined_quality](insight:bTB9yOF)

これは、作業者がすべての機械を個別に監視できない製造業で遭遇する典型的な問題で、[プロジェクトの目的と価値](article:2)で説明したように、中間品質管理のないインライン作業により、機械の異常の始まりから発見までの時間が長くなってしまうのです。

<br>
## ドリフト検知・警報装置
ダッシュボードの3番目のタブの目的は、機械学習モデルを使わずにドリフトを検出し、ドリフトが検出されたときに他のチームにアラートすることです。ドリフト検知の仕組みは全て[ドリフト検知＆アラート](article:13)で解説しています。

<br>
## 製造工程の理解度向上
モデルが良い結果を出したら、その結果を理解するためにDataikuの説明可能性機能が役に立ちます。
このソリューションでは、いくつかの特徴が抽出される時系列アプローチなしでランダムフォレストをトレーニングしました、それはユニタリースコアリングにのみ有効です。モデルの詳細については、[欠陥予測に関する記事](article:12)を参照してください。

[欠陥予測ダッシュボード](dashboard:hbZqqVP)は製造プロセスの理解を強化する方法を示しています。
それは、結果が適切であることを確認するために非常に重要であるモデル評価から始まります。
また、射出時間が非常に大きい影響を与えることがわかる特徴の重要性もあります。
![variable_importance.png](cVuZB0UAFIrd)

最後に、最初のタブにある部分依存性プロットは、予測された応答が単一の特徴に依存することを示します。これは、品質結果と与えられたプロセス変数の間のリンクを理解するのに便利です。
![pdp.png](8jOV974upNMb)
モデルの結果を調べるもう一つの方法は、ダッシュボードの2番目のタブで利用できる[ インタラクティブスコアリング ](https://doc.dataiku.com/dss/latest/machine-learning/supervised/interactive-scoring.html)です。モデルの入力機能を微調整して、その予測と関連する説明をリアルタイムで見るのに便利です。
![interactive_scoring.png](prNf7NYC1P3F)
<br>
## 生産ラインへのライブインサイト
生産チームを巻き込み、情報を伝達する良い方法は、ビジュアルな管理を現場に直接表示することです。そのために、生産データからの情報だけでなく、機械学習モデルからの結果も表示する「生産品質ダッシュボード」を作りました。 
ダッシュボードについては、[生産品質ダッシュボードの記事](article:16)]で詳しく解説しています。
![production_quality_control.png](2S03wKjOyOjg)
<br>
## 結論
コーディングなしで、機械学習モデルによって製造不良の検出時間を短縮し、Dataikuの説明可能な機能を使って製造工程をより良く理解するためのいくつかのアプローチを見てきました。ドリフト検出システムは、ライブアラートで保守などの他のチームを巻き込むのに役立ち、最終的には、現場にライブインサイトが表示されるようになります。
