from process_mining.filtering import *
from datetime import datetime
from dash import html
from webapp.selectors import *
from webapp.attribute_selectors import attribute_filters
from webapp.styles import *

def apply_filters(workflow_df, start_date, end_date, contained,
                 start_steps, end_steps, case_performance, case_performance_scale,
                 attributes_columns, attribute_scales,
                 *attributes):
    if 'Z' in start_date:
        start_date = datetime.strptime(start_date, '%Y-%m-%dT%H:%M:%S.%fZ')
    elif '+00:00' in start_date:
        try:
            start_date = datetime.strptime(start_date, '%Y-%m-%dT%H:%M:%S+00:00')
        except:
            start_date = datetime.strptime(start_date, '%Y-%m-%dT%H:%M:%S.%f+00:00')
    else:
        try:
            start_date = datetime.strptime(start_date, '%Y-%m-%dT%H:%M:%S')
        except:
            start_date = datetime.strptime(start_date, '%Y-%m-%dT%H:%M')
    if 'Z' in end_date:
        end_date = datetime.strptime(end_date, '%Y-%m-%dT%H:%M:%S.%fZ')
    elif '+00:00' in end_date:
        try:
            end_date = datetime.strptime(end_date, '%Y-%m-%dT%H:%M:%S+00:00')
        except:
            end_date = datetime.strptime(end_date, '%Y-%m-%dT%H:%M:%S.%f+00:00')
    else:
        try:
            end_date = datetime.strptime(end_date, '%Y-%m-%dT%H:%M:%S')
        except:
            end_date = datetime.strptime(end_date, '%Y-%m-%dT%H:%M')
    filtered_workflow = filter_timestamp(workflow_df, start_date, end_date, contained)
    if start_steps:
        filtered_workflow = filter_start_step(filtered_workflow, start_steps)
    if end_steps:
        filtered_workflow = filter_end_step(filtered_workflow, end_steps)
    filtered_workflow = filter_case_performance(filtered_workflow, case_performance[0], case_performance[1], case_performance_scale)
    for i, attribute in enumerate(attributes):
        if attribute is not None:
            if len(attribute)>0:
                filtered_workflow = filter_attributes(filtered_workflow, attributes_columns[i], attribute, attribute_scales)
    return filtered_workflow

def base_filters(timeframe_df, start_end_df, attributes_values_df, attributes_columns, attributes_numeric, attribute_scales):
    return html.Div(id='base-filters',
                        children=[
                         filter_element('Starting at', 
                                        single_datetime_filter_picker(timeframe_df['timestamp_min'].iloc[0], True)),
                         filter_element('Ending at', 
                                        single_datetime_filter_picker(timeframe_df['timestamp_max'].iloc[0], False)),
                         filter_element_toggle('Traces must be strictly within range', 
                                        contained_intersecting(True)),
                         filter_element('Starting activities', start_step(start_end_df, None)),
                         filter_element('Ending activities', end_step(start_end_df, None)),
                         filter_element_range('Traces duration', case_performance_slider([0, 100])),
                         html.Div(attribute_filters(attributes_values_df, attributes_columns, attributes_numeric, attribute_scales), id='attribute-filters')])
