from dash import html
import dash_bootstrap_components as dbc

header_children = [html.H5('Discovery', style={'color': '#000000',
                                                         'font-weight': '400',
                                                          'font-size': '18px',
                                                         'display': 'inline-block',
                                                         'margin-right': '7px'}),
                                            html.I(id='question-tooltip',
                                                   className="fas fa-question-circle",
                                                  style={'display': 'inline-block', 
                                                         'color': '#000000'})]

header_conformance_children = [html.H5('Conformance', style={'color': '#000000',
                                                         'font-weight': '400',
                                                          'font-size': '18px',
                                                         'display': 'inline-block',
                                                         'margin-right': '7px'}),
                                            html.I(id='question-tooltip',
                                                   className="fas fa-question-circle",
                                                  style={'display': 'inline-block', 
                                                         'color': '#000000'})]

def filter_header():
    return html.Div(children=header_children, 
                    id='filter-header')

def filter_subtitle():
    return dbc.Row([dbc.Col(children=html.P('Selectors', 
                                            style={'font-weight': 'bold', 'text-align': 'left', 'margin-bottom': 0}), md=8,
                           id='filter-subtitle'),
           dbc.Col(html.Button(html.I(id='expand-selector',
                   className="fas fa-chevron-right"),
                   id='expand-selector-button',
                   className="ml-auto close",
                  style={'float': 'right',
                        'border-width': '0px',
                        'background-color': 'white'}), md=4)],
                  style={'clear': 'both', 'padding-top': '8px'})

def exclude_subtitle():
    return dbc.Row([dbc.Col(children=html.P('Data cleaning', 
                                            style={'font-weight': 'bold', 'text-align': 'left', 'margin-bottom': 0}), md=8,
                           id='exclude-subtitle'),
           dbc.Col(html.Button(html.I(id='expand-filters',
                   className="fas fa-chevron-right"),
                   id='expand-filter-button',
                   className="ml-auto close",
                  style={'float': 'right',
                        'border-width': '0px',
                        'background-color': 'white'}), md=4)],
                  style={'clear': 'both', 'margin-top': '16px'})
