import dash_bootstrap_components as dbc
from dash import html, dcc
from webapp.styles import *
from webapp.legend import legend_object
from webapp.save_modal import save_modal, save_process_modal
from webapp.export_modal import export_modal, export_modal_edge
from webapp.selected_elements import empty_card, empty_card_individual
import dash_daq as daq

time_frequency = html.Div(dbc.RadioItems(
    id="time-frequency",
    className="btn-group btn-group-sm custom-radio-group",
    inputClassName="btn-check",
    labelClassName="btn btn-custom",
    labelCheckedClassName="active",
    options=[
        {"label": "Frequency View", "value": "frequency"},
        {"label": "Time View", "value": "time"}
    ],
    value="frequency"
    ),
    className="time-frequency-container",
    style={"margin-left": "6px"})

variants_conformance_tabs = dbc.Tabs(
    [
        dbc.Tab(label="Top Variants", tab_id="top-variants-tab", labelClassName="fw-bold"),
        dbc.Tab(label="Conformance", tab_id="conformance-tab", labelClassName="fw-bold"),
    ],
    id="variants-conformance-tabs",
    active_tab="top-variants-tab",
    style={'margin-bottom': '6px'}
)


def layout_discovery(project_key):
    left_style = tab_button_style_freq_time_active.copy()
    left_style['border-right'] = '1px solid #666666'
    return [
        html.Div([
            html.Div(id='graph-legend', 
             children=legend_object(1, 100), style={'display': 'flex', 'justify-content': 'flex-start'}),
            html.Div([
                html.Button([
                    html.I(className="fas fa-table", style={'margin-right': '4px'}),
                    'Save as Reference Process'
                ], 
                id='save-process-button', 
                title="Save Displayed Variants as Reference Process",
                style=button_save_style),
                html.Button(
                    html.I(className="fas fa-download"), 
                    id='save-viz', 
                    title="Export Visualization as PNG",
                    style=button_save_style
                )
            ], id='buttons-save-process', style={'display': 'flex', 'justify-content': 'flex-end', 'margin-top': '-12px'})
        ], style={
            'display': 'flex',
            'justify-content': 'space-between', 
            'align-items': 'center',
            'margin-top': 0,
            'margin-bottom': '12px',
            'padding-right': '18px'
        }),
            save_modal(project_key),
            save_process_modal(project_key),
            export_modal(project_key),
            export_modal_edge(project_key),
            dcc.Location(id='location'),
             dbc.Card(id='selected',
                      className='w-25',
                      children=empty_card(),
                     style={'position': 'absolute',
                            'z-index': '999999',
                            'display': 'None'}),
        
             dcc.Loading(id='graph-loading', type='circle', 
                         children=html.Div(id='graph-workflow'))
               ]
