import dataiku
import pandas as pd
from process_mining.process_mining import mine_process
import time

def save_process_in_dataset(project, data, variants):
    variant_ids = set(data['variant_rank'])
    ref_process = variants.loc[variants['variant_rank'].isin(variant_ids)]
    dataset = project.get_dataset("reference_process")
    if not dataset.exists():
        dataset = project.get_dataset("workflow_with_variants")
        settings = dataset.get_settings()
        params = settings.settings['params']
        params['path'] = params['path'].replace('workflow_with_variants', 'reference_process')
        dataset = project.create_dataset(dataset_name="reference_process", type=settings.type,
                             params=params, formatType=settings.settings['formatType'],
                             formatParams=settings.settings['formatParams'])
        new_settings = dataset.get_settings()
        new_settings.settings["managed"] = True
        new_settings.save()
    reference_process = dataiku.Dataset("reference_process")
    reference_process.write_with_schema(ref_process)
    
    # clear conformance dataset
    conformance_dataset = project.get_dataset('conformance_checks')
    conformance_dataset.clear()