import dash_bootstrap_components as dbc
from dash import html, dcc

def save_modal(project_key):
    return dbc.Modal([
            dbc.ModalHeader(dbc.ModalTitle("Save Visualization", style={'font-size': '14px'})),
            dbc.ModalBody(dbc.Col([dbc.Row([
                dbc.Col(html.P("Name", style={'font-size': '12px'}), md=4),
                dbc.Col(dbc.Input(id="viz-name", placeholder="Visualization name", type="text", size='sm'), md=8)])
#                    dcc.Link("Browse through the saved visualizations in this folder", 
#                             href="/projects/" + project_key + "/managedfolder/LsTJHTYd/view/",
#                             target="_blank",
#                            style={'font-size': '12px'})
                  ])),
            dbc.ModalFooter(dbc.Row([
                dbc.Col(dbc.Button(
                    "Cancel",
                    id="cancel-save",
                    color="light",
                    className="sm",
                    n_clicks=0,
                ), md=6),
                dbc.Col(dbc.Button(
                    "Save",
                    id="modal-save-viz",
                    className="sm",
                    n_clicks=0
                ), md=6)])
            ),
        ],
        id="save-modal",
        is_open=False)

def save_process_modal(project_key):
    return dbc.Modal([
            dbc.ModalHeader(dbc.ModalTitle("Save Process", style={'font-size': '14px'})),
            dbc.ModalBody(dbc.Col([html.P("Saving the process will overwrite the existing saved process."),
                                    dcc.Link("Browse through the variants of the saved process in this dataset", 
                            href="/projects/" + project_key + "/datasets/reference_process/explore/",
                            target="_blank",
                           style={'font-size': '12px'})])),
            dbc.ModalFooter(dbc.Row([
                dbc.Col(dbc.Button(
                    "Cancel",
                    id="cancel-save-process",
                    color="light",
                    className="sm",
                    n_clicks=0,
                ), md=6),
                dbc.Col(dbc.Button(
                    "Save",
                    id="modal-save-process",
                    className="sm",
                    n_clicks=0
                ), md=6)])
            ),
        ],
        id="save-process-modal",
        is_open=False)